% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.tree.R
\name{as.rtree}
\alias{as.rtree}
\alias{as.rtree.rtree}
\alias{as.rtree.character}
\alias{as.rtree.data.frame}
\title{Conversion to an 'rtree' object}
\usage{
as.rtree(x, ...)

\method{as.rtree}{rtree}(x, ...)

\method{as.rtree}{character}(x, ...)

\method{as.rtree}{data.frame}(x, ...)
}
\arguments{
\item{x}{An object to be converted.}

\item{...}{Additional parameters (not used).}
}
\value{
An \code{rtree} object.
}
\description{
These methods convert an object to an \code{rtree} object.
}
\examples{
## Rooted tree
df = data.frame(x = c("A", "A", "A", "A"), 
                y = c("B", "C", "C", "C"), 
                z = c("D", "E", "E", "F"), 
                stringsAsFactors = FALSE)
                
(as.rtree(df))

## Unrooted tree
df = data.frame(x = c("A", "A", "A", "X"), 
                y = c("B", "C", "C", "Y"), 
                z = c("D", "E", "E", "Z"), 
                stringsAsFactors = FALSE)
                
(as.rtree(df))

}
