% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{rtree}
\alias{rtree}
\alias{r_}
\alias{empty_tree}
\alias{is_empty}
\alias{is_empty.default}
\alias{is_empty.rtree}
\title{Tree constructor}
\usage{
rtree(label = NULL, subtrees = list(), ...)

r_(label = NULL, subtrees = list(), ...)

empty_tree()

is_empty(x)

\method{is_empty}{default}(x)

\method{is_empty}{rtree}(x)
}
\arguments{
\item{label}{character. The label of the root of the tree created. 
If \code{label=NULL}, the tree created is unrooted. 
If \code{label=NULL} and \code{subtrees=list()}, the tree 
created is the empty tree.}

\item{subtrees}{A (possibly empty) list of \code{rtree} objects. 
These rtrees must be rooted, otherwise an error is thrown.}

\item{...}{Additional arguments to be passed as attributes to each 
node of the tree.}

\item{x}{A tree.}
}
\value{
An \code{rtree} object.
}
\description{
The function \code{rtree} creates an 'rtree' (recursive tree) object.
}
\examples{
## Chains
(tr0 = c_("Bob", "Carl", "Daniel"))
(tr1 = c_("Bill", "Caroline", "Dimitri", "Enoc"))

## Rooted tree
(tr2 = r_("Alice", s = list(tr0, tr1)))

## Unrooted tree
(tr3 = r_(s = list(tr2, c_("Grand-Mother", "Father", "Son"))))
             
}
