% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow.R
\name{occTest}
\alias{occTest}
\title{Occurrence tests}
\usage{
occTest(
  sp.name,
  habitat = NULL,
  sp.table,
  r.env,
  tableSettings = NULL,
  analysisSettings = NULL,
  writeoutSettings = NULL,
  gradingSettings = NULL,
  return.spatial.data = FALSE,
  r.dem = NULL,
  ntv.ctry = NULL,
  inv.ctry = NULL,
  resolveAlienCtry = FALSE,
  resolveNativeCtry = FALSE,
  interactiveMode = FALSE,
  verbose = FALSE,
  doParallel = FALSE,
  mc.cores = 2
)
}
\arguments{
\item{sp.name}{character. Name of the species.}

\item{habitat}{NULL}

\item{sp.table}{data.frame. Object with the coordinate data.}

\item{r.env}{raster or rasterStack. Environmental data(e.g. typically climatic.}

\item{tableSettings}{list. Elements corresponding to different settings of the input occurrence table.}

\item{analysisSettings}{list. Elements corresponding to different settings of the analysis functions .}

\item{writeoutSettings}{list. Elements corresponding to different settings of the analysis functions .}

\item{gradingSettings}{list. Not implemented yet. Defaults to NULL.Elements corresponding to different settings of the analysis functions .}

\item{return.spatial.data}{logical. Should the spatial dataset of \code{analysisSettings} attached to the metadata?, default is FALSE to save memory}

\item{r.dem}{raster. Elevation data (in meters).}

\item{ntv.ctry}{character. vector with ISO3 code of the countries where species is considered native}

\item{inv.ctry}{character. vector with ISO3 code of the countries where species is considered invasive}

\item{resolveAlienCtry}{logical. To automatically try to detect  countries for which species is considered native}

\item{resolveNativeCtry}{logical. To automatically try to detect  countries for which species is considered alien}

\item{interactiveMode}{logical. Should prompts be ouput for some decisions taken by the workflow? Deafult FALSE,}

\item{verbose}{logical. Print workflow information? Default to FALSE}

\item{doParallel}{logical. Should some operations be run in parellel when possible? Default to FALSE}

\item{mc.cores}{numeric. If doParallel is TRUE, then how many cores to use? Default to 2}
}
\value{
data frame with the tests performed (field $_test), specific comment for the tests ($_comments), the exact value of the test ($_value), and scores summarizing results across tests with an objective ($_score)
}
\description{
Perform tests for data quality in species occurrence  using several methods
}
\note{
The output dataframe allows users to classify or scrub the occurrences the way they want to. \cr
The names of the columns in the output object have the following naming convention: \cr
$AnalysisType$_$SpecificTest$_value: numeric or logical. Shows the quantitative result of the test (sometimes the same as in the result of the _test) \cr
$AnalysisType$_$SpecificTest$_test: logical Shows whether the occurrence passes or not the test, being TRUE a flag for a wrong record and NA indicating that the test was not performed on that record. \cr
$AnalysisType$_$SpecificTest$_comment: character. Shows some comments related to the specific test.\cr
Examples: HumanDetection_HumanInfluence_value gives you the score of current human influence in the record HumanDetection_HumanInfluence_test gives you whether we consider the former value an error/bias (TRUE) or not (FALSE) HumanDetection_HumanInfluence_comment gives you a commen that give further detail on the analysis. In this case that the threshold of 45 was used for the test. HumanDetection_score summarizes all the other HumanDetection tests and outputs a value from 0 to 1. A value of 0.5 would indicate that half of the tests used indicate that is an a Human signal in the record.
}
\examples{
\donttest{
### THIS IS A CUT DOWN  EXAMPLE 
### visit vignetteXtra-occTest for more info
#load environmental raster
library (raster)
library (sf)
library (occTest)
#load occurrence data
occData <- read.csv (system.file('ext/exampleOccData.csv',package = 'occTest'))
#load environmental raster
renv <- raster (system.file('ext/AllEnv.tif',package = 'occTest'))
#load elevation raster
dem <- raster (system.file('ext/DEM.tif',package = 'occTest'))
#load settings
settings <- readRDS (system.file('ext/exSettings.rds',package = 'occTest'))
#run occTest
out = occTest(sp.name='MyFake species',
             sp.table = occData,ntv.ctry = 'ESP',inv.ctry = 'FRA',
             tableSettings = settings$tableSettings,
             writeoutSettings = settings$writeoutSettings,
             analysisSettings = settings$analysisSettings,
             r.env = renv,r.dem=dem)
}
}
