% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section.R
\docType{methods}
\name{plot,section-method}
\alias{plot,section-method}
\title{Plot a Section}
\usage{
\S4method{plot}{section}(x, which = c(1, 2, 3, 99),
  eos = getOption("oceEOS", default = "gsw"), at = NULL, labels = TRUE,
  grid = FALSE, contourLevels = NULL, contourLabels = NULL,
  stationIndices, coastline = c("best", "coastlineWorld",
  "coastlineWorldMedium", "coastlineWorldFine", "none"), xlim = NULL,
  ylim = NULL, map.xlim = NULL, map.ylim = NULL, clongitude, clatitude,
  span, projection = NULL, xtype = c("distance", "track", "longitude",
  "latitude", "time"), ytype = c("depth", "pressure"), ztype = c("contour",
  "image", "points"), zbreaks = NULL, zcol = NULL,
  legend.loc = "bottomright", adorn = NULL, showStations = FALSE,
  showStart = TRUE, showBottom = TRUE, axes = TRUE,
  mgp = getOption("oceMgp"), mar = c(mgp[1] + 1, mgp[1] + 1, mgp[2] + 1,
  mgp[2] + 0.5), col = par("col"), cex = par("cex"), pch = par("pch"),
  debug = getOption("oceDebug"), ...)
}
\arguments{
\item{x}{a \code{section} object, e.g. as created by \code{\link{as.section}}
or \code{\link{read.section}}.}

\item{which}{a list of desired plot types, as explained in \dQuote{Details}.
There may be up to four panels in total, and the desired plots are placed in
these panels, in reading order.  If only one panel is plotted, \code{par} is
not adjusted, which makes it easy to add to the plot with subsequent plotting
commands.}

\item{eos}{Character string indicating the equation of state to be used, either
\code{"unesco"} or \code{"gsw"}.}

\item{at}{If \code{NULL} (the default), the x axis will indicate the distance
of the stations from the first in the section.  (This may give errors in the
contouring routine, if the stations are not present in a geographical order.)
If a list, then it indicates the values at which stations will be plotted.}

\item{labels}{Either a logical, indicating whether to put labels on the x axis,
or a vector that is a list of labels to be placed at the x positions indicated
by \code{at}.}

\item{grid}{If \code{TRUE}, points are drawn at data locations.}

\item{contourLevels}{Optional contour levels.}

\item{contourLabels}{Optional contour labels.}

\item{stationIndices}{Optional list of the indices of stations to use.  Note
that an index is \emph{not} a station number, e.g. to show the first 4
stations, use \code{station.indices=1:4}.}

\item{coastline}{String giving the coastline to be used in a station map, or
\code{"best"} to pick the one with highest resolution, or \code{"none"} to
avoid drawing the coastline.}

\item{xlim}{Optional limit for x axis (only in sections, not map).}

\item{ylim}{Optional limit for y axis (only in sections, not map)}

\item{map.xlim, map.ylim}{Optional limits for station map; \code{map.ylim} is
ignored if \code{map.xlim} is provided.}

\item{clongitude, clatitude, span}{Optional map centre position and span (km).}

\item{projection}{Parameter specifying map
projection; see \code{\link{mapPlot}}.  If \code{projection="automatic"},
however, a projection is devised from the data, with \code{stereographic} if
the mean latitude exceeds 70N and \code{mollweide} otherwise.}

\item{xtype}{Type of x axis, for contour plots, either \code{"distance"} for
distance (in km) to the first point in the section, \code{"track"} for distance
along the cruise track, \code{"longitude"}, \code{"latitude"}, or
\code{"time"}.  Note that if the x values are not in order, they will be put in
order (which may make no sense) and a warning will be printed.}

\item{ytype}{Type of y axis for contour plots, either \code{"pressure"} for
pressure (in dbar, with zero at the surface) or \code{"depth"} for depth (in m
below the surface, calculated from pressure with \code{\link{swDepth}}).}

\item{ztype}{String indicating whether to use contours, an image, or points.
In the first two cases, the data must be gridded, with identical pressures at
each station.}

\item{zbreaks, zcol}{Breaks and colours to be used if \code{ztype="points"} or
\code{"image"}.  If not provided, a reasonable default is chosen.  If
\code{zcol} is a function, it will be invoked with an argument equal to
\code{1+length(zbreaks)}.  If \code{zbreaks} is not given, it defaults to a
vector of length 200, with values spanning the data range.}

\item{legend.loc}{Location of legend, as supplied to \code{\link{legend}}, or
set to the empty string to avoid plotting a legend.}

\item{adorn}{(\strong{Defunct})
An \code{\link{expression}} or vector of expressions that contain
R code that is to be executed immediately after each panel of the plot.
If the number of expressions matches the number of panels, then the 
expressions are used for the corresponding panels; otherwise, the
expression list is extended to match the number of panels (i.e.
to obtain \code{length(which)} elements). Note that \code{adorn}
is a dangerous argument, because if the expressions contained
therein set up local storage, there is a chance of entirely
disrupting the plotting. \strong{For this reason, \code{adorn} was
marked as defunct in June 2016, and will be removed entirely 
after the July CRAN release.} Users with existing code that uses
\code{adorn} should simply plot the panels individually, and
use conventional R functions, e.g. \code{\link{lines}} etc.,
after each panel, to achieve the desired effect.  (See
\code{\link{oce-defunct}} for notes on other deprecated or
defunct \code{oce} features.)}

\item{showStations}{Logical indicating whether to draw station numbers on maps.}

\item{showStart}{Logical indicating whether to indicate the first station with
a different symbol than the others.}

\item{showBottom}{Logical indicating whether to draw the bottom, or a character
string indicating the method for plotting the bottom.  The allowed methods are:
\code{polygon}, which fills the space to the bottom, or \code{lines}, which
draws lines from stations to the bottom, or \code{points}, which draws points
at the bottom.}

\item{axes}{Logical value indicating whether to draw axes.}

\item{mgp}{3-element numerical vector to use for \code{par(mgp)}, and also for
\code{par(mar)}, computed from this.  The default is tighter than the R
default, in order to use more space for the data and less for the axes.}

\item{mar}{Value to be used with \code{\link{par}("mar")}.}

\item{col}{Colour, as in \code{\link{par}("col")}.}

\item{cex}{Value to be used with \code{\link{par}("cex")}, for any use of
\code{\link{points}}, e.g. for \code{which="data"}.}

\item{pch}{Value to be used with \code{\link{par}("pch")} (see \code{cex},
above.)}

\item{debug}{A flag that turns on debugging.  Set to 1 to get a moderate amount
of debugging information, or to 2 to get more.}

\item{...}{Optional arguments passed to the contouring function, e.g. using
\code{labcex=1} will increase the size of contour labels.}
}
\value{
If the original section was gridded, the return value is that section.
Otherwise, the gridded section that was constructed for the plot is returned.
In both cases, the value is returned silently. The
purpose of returning the section is to enable subsequent processing
of the grid, including adding elements to the plot.
}
\description{
Creates a summary plot for a CTD section, with one panel for each value of
\code{which}.
}
\details{
The type of plot is governed by \code{which}, as follows.

\itemize{  
    \item \code{which=1} or \code{"temperature"} for temperature contours (the default)
    \item \code{which=2} or \code{"salinity"} for salinity contours
    \item \code{which=3} or \code{"sigmaTheta"} for sigma-theta contours
    \item \code{which=4} or \code{"nitrate"} for nitrate concentration contours
    \item \code{which=5} or \code{"nitrite"} for nitrite concentration contours
    \item \code{which=6} or \code{"oxygen"} for oxygen concentration  contours
    \item \code{which=7} or \code{"phosphate"} for phosphate concentration contours
    \item \code{which=8} or \code{"silicate"} for silicate concentration contours
    \item \code{which=9} or \code{"u"} for eastward velocity
    \item \code{which=10} or \code{"uz"} for vertical derivative of eastward velocity
    \item \code{which=11} or \code{"v"} for northward velocity
    \item \code{which=12} or \code{"vz"} for vertical derivative of northward velocity
    \item \code{which=20} or \code{"data"} for a dot for each data location
    \item \code{which=99} or \code{"map"} for a location map
}

The y-axis for the contours is pressure, plotted in the conventional reversed
form, so that the water surface appears at the top of the plot.  The x-axis is
more complicated. If \code{at} is not supplied, then the routine calculates x
as the distance between the first station in the section and each of the other
stations. (This will produce an error if the stations are not ordered
geographically, because the \code{\link{contour}} routine cannot handle
non-increasing axis coordinates.) If \code{at} is specified, then it is taken
to be the location, in arbitrary units, along the x-axis of labels specified by
\code{labels}; the way this works is designed to be the same as for
\code{\link{axis}}.
}
\examples{
library(oce)
data(section)
sg <- sectionGrid(section)

## 1. AO3 section, default fields.
plot(section)

## 2. Gulf Stream
GS <- subset(section, 109<=stationId&stationId<=129)
GSg <- sectionGrid(GS, p=seq(0,2000,100))
plot(GSg, which=c(1,99), map.ylim=c(34,42))
par(mfrow=c(2,1))
plot(GS, which=1, ylim=c(2000, 0), ztype='points',
     zbreaks=seq(0,30,2), pch=20, cex=3)
plot(GSg, which=1, ztype='image', zbreaks=seq(0,30,2))

par(mfrow=c(1,1))

## 3. Image, with coloured dots to indicate grid-data mismatch.
plot(GSg, which=1, ztype='image')
T <- GS[['temperature']]
col <- oce.colorsJet(100)[rescale(T, rlow=1, rhigh=100)]
points(GS[['distance']],GS[['depth']],pch=20,cex=3,col='white')
points(GS[['distance']],GS[['depth']],pch=20,cex=2.5,col=col)


}
\author{
Dan Kelley
}
\seealso{
The documentation for \code{\link{section-class}} explains the
structure of section objects, and also outlines the other functions dealing
with them.

Other functions that plot \code{oce} data: \code{\link{plot,adp-method}},
  \code{\link{plot,adv-method}},
  \code{\link{plot,amsr-method}},
  \code{\link{plot,argo-method}},
  \code{\link{plot,bremen-method}},
  \code{\link{plot,cm-method}},
  \code{\link{plot,coastline-method}},
  \code{\link{plot,ctd-method}},
  \code{\link{plot,gps-method}},
  \code{\link{plot,ladp-method}},
  \code{\link{plot,lisst-method}},
  \code{\link{plot,lobo-method}},
  \code{\link{plot,met-method}},
  \code{\link{plot,odf-method}},
  \code{\link{plot,rsk-method}},
  \code{\link{plot,satellite-method}},
  \code{\link{plot,sealevel-method}},
  \code{\link{plot,tidem-method}},
  \code{\link{plot,topo-method}},
  \code{\link{plot,windrose-method}},
  \code{\link{plotProfile}}, \code{\link{plotScan}},
  \code{\link{plotTS}}, \code{\link{tidem-class}}

Other things related to \code{section} data: \code{\link{[[,section-method}},
  \code{\link{[[<-,section-method}},
  \code{\link{as.section}},
  \code{\link{handleFlags,section-method}},
  \code{\link{read.section}}, \code{\link{section-class}},
  \code{\link{sectionAddStation}},
  \code{\link{sectionGrid}}, \code{\link{sectionSmooth}},
  \code{\link{sectionSort}}, \code{\link{section}},
  \code{\link{subset,section-method}},
  \code{\link{summary,section-method}}
}

