% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odf.R
\docType{methods}
\name{plot,odf-method}
\alias{plot,odf-method}
\title{Plot an ODF Object}
\usage{
\S4method{plot}{odf}(x)
}
\arguments{
\item{x}{A \code{odf} object, e.g. one inheriting from \code{\link{odf-class}}.}
}
\description{
Plot data contained within an ODF object,
using \code{\link{oce.plot.ts}} to create panels of time-series plots for all
the columns contained in the \code{odf} object. If the object's \code{data}
slot does not contain \code{time}, then \code{\link{pairs}} is used to plot
all the elements in the slot. These actions are both crude and there are
no arguments to control the behaviour, but this function is really just a stop-gap
measure, since in practical work \code{odf} objects are usually cast to other types,
and those types tend to have more useful plots.
}
\seealso{
Other functions that plot \code{oce} data: \code{\link{plot,adp-method}},
  \code{\link{plot,adv-method}},
  \code{\link{plot,amsr-method}},
  \code{\link{plot,argo-method}},
  \code{\link{plot,bremen-method}},
  \code{\link{plot,cm-method}},
  \code{\link{plot,coastline-method}},
  \code{\link{plot,ctd-method}},
  \code{\link{plot,gps-method}},
  \code{\link{plot,ladp-method}},
  \code{\link{plot,lisst-method}},
  \code{\link{plot,lobo-method}},
  \code{\link{plot,met-method}},
  \code{\link{plot,rsk-method}},
  \code{\link{plot,satellite-method}},
  \code{\link{plot,sealevel-method}},
  \code{\link{plot,section-method}},
  \code{\link{plot,tidem-method}},
  \code{\link{plot,topo-method}},
  \code{\link{plot,windrose-method}},
  \code{\link{plotProfile}}, \code{\link{plotScan}},
  \code{\link{plotTS}}, \code{\link{tidem-class}}

Other things related to \code{odf} data: \code{\link{ODF2oce}},
  \code{\link{ODFNames2oceNames}},
  \code{\link{[[,odf-method}},
  \code{\link{[[<-,odf-method}}, \code{\link{odf-class}},
  \code{\link{read.ctd.odf}}, \code{\link{read.odf}},
  \code{\link{subset,odf-method}},
  \code{\link{summary,odf-method}}
}
\author{
Dan Kelley
}
