% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{plotSticks}
\alias{plotSticks}
\title{Draw a Stick Plot}
\usage{
plotSticks(x, y, u, v, yscale = 1, add = FALSE, length = 1/20,
  mgp = getOption("oceMgp"), mar = c(mgp[1] + 1, mgp[1] + 1, 1, 1 +
  par("cex")), xlab = "", ylab = "", col = 1, ...)
}
\arguments{
\item{x}{x coordinates of stick origins.}

\item{y}{y coordinates of stick origins.  If not supplied, 0 will be used;
if length is less than that of x, the first number is repeated and the rest
are ignored.}

\item{u}{x component of stick length.}

\item{v}{y component of stick length.}

\item{yscale}{scale from u and v to y (see \dQuote{Description}).}

\item{add}{boolean, set \code{TRUE} to add to an existing plot.}

\item{length}{value to be provided to \code{\link{arrows}}; here, we set a
default that is smaller than normally used, because these plots tend to be
crowded in oceanographic applications.}

\item{mgp}{3-element numerical vector to use for \code{par(mgp)}, and also
for \code{par(mar)}, computed from this.  The default is tighter than the R
default, in order to use more space for the data and less for the axes.}

\item{mar}{value to be used with \code{\link{par}("mar")}.}

\item{xlab, ylab}{labels for the plot axes. The default is not to label them.}

\item{col}{color of sticks, in either numerical or character format. This is
made to have length matching that of \code{x} by a call to \code{\link{rep}},
which can be handy in e.g. colorizing a velocity field by day.}

\item{\dots}{graphical parameters passed down to \code{\link{arrows}}.  It
is common, for example, to use smaller arrow heads than \code{\link{arrows}}
uses; see \dQuote{Examples}.}
}
\description{
The arrows are drawn with directions on the graph that match the directions
indicated by the \code{u} and \code{v} components. The arrow size is set
relative to the units of the \code{y} axis, according to the value of
\code{yscale}, which has the unit of \code{v} divided by the unit of
\code{y}.
The interpretation of diagrams produced by \code{plotSticks} can be
difficult, owing to overlap in the arrows.  For this reason, it is often
a good idea to smooth \code{u} and \code{v} before using this function.
}
\examples{

library(oce)

# Flow from a point source
n <- 16
x <- rep(0, n)
y <- rep(0, n)
theta <- seq(0, 2*pi, length.out=n)
u <- sin(theta)
v <- cos(theta)
plotSticks(x, y, u, v, xlim=c(-2, 2), ylim=c(-2, 2))
rm(n, x, y, theta, u, v)

# Oceanographic example
data(met)
t <- met[["time"]]
u <- met[["u"]]
v <- met[["v"]]
p <- met[["pressure"]]
oce.plot.ts(t, p)
plotSticks(t, 99, u, v, yscale=25, add=TRUE)
}
\author{
Dan Kelley
}
