% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landsat.R
\docType{methods}
\name{[[,landsat-method}
\alias{[[,landsat-method}
\title{Extract Something From a landsat Object}
\usage{
\S4method{[[}{landsat}(x, i, j, ...)
}
\arguments{
\item{x}{An landsat object, i.e. one inheriting from \code{\link{landsat-class}}.}

\item{i}{Character string indicating the name of item to extract.}

\item{j}{Optional additional information on the \code{i} item.}

\item{...}{Optional additional information (ignored).}
}
\description{
The \code{[[} method works for all \code{oce} objects, i.e.
objects inheriting from \code{\link{oce-class}}.  The purpose
is to insulate users from the internal details of \code{oce}
objects, by looking for items within the various storage
slots of the object. Items not actually stored can also be
extracted, including derived data, units of measurement,
and data-quality flags.
}
\details{
A two-step process is used to try to find the
requested information. First, a class-specific function
tries to find it (see
\dQuote{Details of the specialized ... method}), but
if that fails, then a general function is used
(see \sQuote{Details of the general method}). If both
fail, \code{NULL} is returned.
}
\section{Details of the general method}{


If the specialized method produces no matches, the following generalized
method is applied. As with the specialized method, the procedure hinges
first on the value of \code{i}.

First, a check is made as to whether \code{i} names one of the standard
\code{oce} slots, and returns the slot contents if so. Thus,
\code{x[["metadata"]]} will retrieve the \code{metadata} slot,
while \code{x[["data"]]} and \code{x[["processingLog"]]} return
those slots.

Next, if \code{i} is a string ending in the
\code{"Unit"}, then the characters preceding that string
are taken to be the name of an item in the data object, and a list
containing the unit is returned. This list consists of an item
named \code{unit}, which is an \code{\link{expression}}, and
an item named \code{scale}, which is a string describing the
measurement scale.  If the string ends in \code{" unit"}, e.g.
\code{x[["temperature unit"]]}, then just the expression is returned,
and if it ends in \code{" scale"}, then just the scale is returned.

Next, if \code{i} is a string ending in \code{"Flag"}, then the corresponding
data-quality flag is returned (or \code{NULL} if there is no such flag).
For example, \code{x[["salinityFlag"]]} returns a vector of salinity
flags if \code{x} is a ctd object.

If none of the preceding conditions are met, a check is done
to see if the \code{metadata} slot contains an item with
the provided name, and that is returned, if so. A direct match
is required for this condition.

Finally, the \code{data} slot is checked to see if it contains
an item with the name indicated by \code{i}. In this case, a partial
match will work; this is accomplished by using \code{\link{pmatch}}.

If none of the above-listed conditions holds, then \code{NULL} is returned.
}

\section{Details of the specialized \code{landsat} method}{


Users are isolated from the details of the two-byte storage system
by using the \code{[[} operator.

\emph{Accessing band data.}  The data may be accessed with e.g.
\code{landsat[["panchromatic"]]}, for the panchromatic band.  If a new
``band'' is added with \code{\link{landsatAdd}}, it may be referred by
name.  In all cases, a second argument can be provided, to govern
decimation.  If this is missing, all the relevant data are returned.  If
this is present and equal to \code{TRUE}, then the data will be
automatically decimated (subsampled) to give approximately 800 elements in
the longest side of the matrix.  If this is present and numerical, then its
value governs decimation.  For example,
\code{landsat[["panchromatic",TRUE]]} will auto-decimate, typically
reducing the grid width and height from 16000 to about 800.  Similarly,
\code{landsat[["panchromatic",10]]} will reduce width and height to about
1600.  On machines with limited RAM (e.g. under about 6GB), decimation is a
good idea in almost all processing steps.  It also makes sense for
plotting, and in fact is done through the \code{decimate} argument of
\code{\link{plot,landsat-method}}.

\emph{Accessing derived data.}  One may retrieve several derived quantities
that are calculated from data stored in the object:
\code{landsat[["longitude"]]} and \code{landsat[["latitude"]]} give pixel
locations.  Accessing \code{landsat[["temperature"]]} creates an estimate
of ground temperature as follows (see [4]).  First, the ``count value'' in
band 10, denoted \eqn{b_{10}}{b_10} say, is scaled with coefficients stored
in the image metadata using
\eqn{\lambda_L=b_{10}M_L+A_L}{lambda_L=b_10*M_L+A_L} where \eqn{M_L}{M_L}
and \eqn{A_L}{A_L} are values stored in the metadata (e.g.  the first in
\code{landsat@metadata$header$radiance_mult_band_10}) Then the result is
used, again with coefficients in the metadata, to compute Celcius
temperature \eqn{T=K_2/ln(\epsilon
    K_1/\lambda_L+1)-273.15}{T=K_2/ln(epsilon*K_1/\lambda_L+1)-273.15}.
The value of the emissivity \eqn{\epsilon}{epsilon} is set to unity by
\code{\link{read.landsat}}, although it can be changed easily later, by
assigning a new value to \code{landsat@metadata$emissivity}. The default
emissivity value set by \code{\link{read.landsat}} is from [11], and is
within the oceanic range suggested by [5]. Adjustment is as simple as
altering \code{landsat@metadata$emissivity}. This value can be a single
number meant to apply for the whole image, or a matrix with dimensions
matching those of band 10.  The matrix case is probably more useful for
images of land, where one might wish to account for the different
emissivities of soil and vegetation, etc.; for example, Table 4 of [9]
lists 0.9668 for soil and 0.9863 for vegetation, while Table 5 of [10]
lists 0.971 and 0.987 for the same quantities.

\emph{Accessing metadata.} Anything in the metadata can be accessed by
name, e.g. \code{landsat[["time"]]}.  Note that some items are simply
copied over from the source data file and are not altered by e.g.
decimation.  An exception is the lat-lon box, which is altered by
\code{\link{landsatTrim}}.
}

\seealso{
Other functions that extract parts of \code{oce} objects: \code{\link{[[,adp-method}},
  \code{\link{[[,adv-method}},
  \code{\link{[[,amsr-method}},
  \code{\link{[[,argo-method}},
  \code{\link{[[,bremen-method}},
  \code{\link{[[,cm-method}},
  \code{\link{[[,coastline-method}},
  \code{\link{[[,ctd-method}},
  \code{\link{[[,echosounder-method}},
  \code{\link{[[,g1sst-method}},
  \code{\link{[[,gps-method}},
  \code{\link{[[,ladp-method}},
  \code{\link{[[,lisst-method}},
  \code{\link{[[,lobo-method}},
  \code{\link{[[,met-method}}, \code{\link{[[,odf-method}},
  \code{\link{[[,rsk-method}},
  \code{\link{[[,sealevel-method}},
  \code{\link{[[,section-method}},
  \code{\link{[[,tidem-method}},
  \code{\link{[[,topo-method}},
  \code{\link{[[,windrose-method}},
  \code{\link{[[<-,adv-method}}

Other things related to \code{landsat} data: \code{\link{[[<-,landsat-method}},
  \code{\link{landsat-class}}, \code{\link{landsatAdd}},
  \code{\link{landsatTrim}}, \code{\link{landsat}},
  \code{\link{plot,landsat-method}},
  \code{\link{read.landsat}},
  \code{\link{summary,landsat-method}}
}
\author{
Dan Kelley
}
\concept{functions that extract parts of \code{oce} objects}
\concept{satellite}
\concept{things related to \code{landsat} data}
