% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\name{initialize,ctd-method}
\alias{initialize,ctd-method}
\title{Initialize storage for a ctd object}
\usage{
\S4method{initialize}{ctd}(
  .Object,
  pressure,
  salinity,
  temperature,
  conductivity,
  units,
  pressureType,
  deploymentType,
  ...
)
}
\arguments{
\item{.Object}{the string \code{"ctd"}}

\item{pressure}{optional numerical vector of pressures.}

\item{salinity}{optional numerical vector of salinities.}

\item{temperature}{optional numerical vector of temperatures.}

\item{conductivity}{optional numerical vector of conductivities.}

\item{units}{optional list indicating units for the quantities specified
in the previous arguments. If this
is not supplied, a default is set up, based on which of the
\code{pressure} to \code{conductivity} arguments were specified.
If all of those 4 arguments were specified, then \code{units} is set
up as if the call included the following:
\code{units=list(temperature=list(unit=expression(degree*C), scale="ITS-90"),
     salinity=list(unit=expression(), scale="PSS-78"),
     conductivity=list(unit=expression(), scale=""),
     pressure=list(unit=expression(dbar), scale=""),
     depth=list(unit=expression(m), scale=""))}. This list is trimmed
of any of the 4 items that were not specified in the previous
arguments. Note that if \code{units} is specified, then it is just
copied into the \code{metadata} slot of the returned object, so the user
must be careful to set up values that will make sense to other \code{oce}
functions.}

\item{pressureType}{optional character string indicating the type of pressure;
if not supplied, this defaults to \code{"sea"}, which indicates the excess of
pressure over the atmospheric value, in dbar.}

\item{deploymentType}{optional character string indicating the type of deployment, which may
be \code{"unknown"}, \code{"profile"}, \code{"towyo"}, or \code{"thermosalinograph"}.
If this is not set, the value defaults to \code{"unknown"}.}

\item{...}{Ignored.}
}
\description{
This function creates \linkS4class{ctd} objects. It is mainly
used by \code{oce} functions such as \code{\link[=read.ctd]{read.ctd()}} and \code{\link[=as.ctd]{as.ctd()}},
and it is not intended for novice users, so it may change at any time, without
following the usual rules for transitioning to deprecated and defunct status
(see \link{oce-deprecated}).
}
\details{
To save storage, this function has arguments only for quantities that are often present in data
files all cases. For example, not
all data files will have oxygen, so that's not present here.
Extra data may be added after the object is created, using
\code{\link[=oceSetData]{oceSetData()}}.
Similarly, \code{\link[=oceSetMetadata]{oceSetMetadata()}} may be used to add metadata (station ID, etc),
while bearing in mind that other functions look for such information
in very particular places (e.g. the station ID is a string named \code{station}
within the \code{metadata} slot). See \linkS4class{ctd} for more information
on elements stored in \code{ctd} objects.
}
\examples{

# 1. empty
new("ctd")

# 2. fake data with no location information, so can only
#    plot with the UNESCO equation of state.
#    NOTE: always name arguments, in case the default order gets changed
ctd <- new("ctd", salinity=35+1:3/10, temperature=10-1:3/10, pressure=1:3)
summary(ctd)
plot(ctd, eos="unesco")

# 3. as 2, but insert location and plot with GSW equation of state.
ctd <- oceSetMetadata(ctd, "latitude", 44)
ctd <- oceSetMetadata(ctd, "longitude", -63)
plot(ctd, eos="gsw")

}
\seealso{
Other things related to ctd data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{[[,ctd-method}},
\code{\link{[[<-,ctd-method}},
\code{\link{as.ctd}()},
\code{\link{cnvName2oceName}()},
\code{\link{ctd-class}},
\code{\link{ctd.cnv}},
\code{\link{ctdDecimate}()},
\code{\link{ctdFindProfiles}()},
\code{\link{ctdRaw}},
\code{\link{ctdRepair}()},
\code{\link{ctdTrim}()},
\code{\link{ctd_aml.csv}},
\code{\link{ctd}},
\code{\link{d200321-001.ctd}},
\code{\link{d201211_0011.cnv}},
\code{\link{handleFlags,ctd-method}},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{oceNames2whpNames}()},
\code{\link{oceUnits2whpUnits}()},
\code{\link{plot,ctd-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{read.ctd.itp}()},
\code{\link{read.ctd.odf}()},
\code{\link{read.ctd.odv}()},
\code{\link{read.ctd.sbe}()},
\code{\link{read.ctd.woce.other}()},
\code{\link{read.ctd.woce}()},
\code{\link{read.ctd}()},
\code{\link{setFlags,ctd-method}},
\code{\link{subset,ctd-method}},
\code{\link{summary,ctd-method}},
\code{\link{woceNames2oceNames}()},
\code{\link{woceUnit2oceUnit}()},
\code{\link{write.ctd}()}
}
\concept{things related to ctd data}
