% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.nortek.ad2cp.R
\name{ad2cpCodeToName}
\alias{ad2cpCodeToName}
\title{Map AD2CP ID Code to oce Name}
\usage{
ad2cpCodeToName(code = NULL, prefix = TRUE)
}
\arguments{
\item{code}{a \link{raw} (or corresponding integer) vector indicating the IDs of
interest, or NULL to get a summary of possible values.}

\item{prefix}{logical value indicating whether to show the raw value as a
prefix (e.g. \code{"0x1c=echosounder"} as opposed to \code{"echosounder"}).}
}
\value{
An indication of the mapping.  If \code{code} is NULL, this is a data
frame.  Otherwise, it is a character vector with the relevant mappings,
with the raw form of the code linked with the name, as in the example.
}
\description{
As explained in Nortek (2022, section 6.1, page 80), AD2CP files use a
hexadecimal (in R, "raw") code to indicate the nature of each data chunk, and
\code{\link[=read.adp.ad2cp]{read.adp.ad2cp()}} uses the present function as it analyses AD2CP files.
}
\details{
The mapping from code (hex or decimal) to oce name is as follows.\tabular{rrr}{
   code (raw) \tab code (integer) \tab oce name \cr
   ---------- \tab -------------- \tab ----------------- \cr
   \code{0x15} \tab 21 \tab \code{burst} \cr
   \code{0x16} \tab 22 \tab \code{average} \cr
   \code{0x17} \tab 23 \tab \code{bottomTrack} \cr
   \code{0x18} \tab 24 \tab \code{interleavedBurst} \cr
   \code{0x1a} \tab 26 \tab \code{burstAltimeterRaw} \cr
   \code{0x1b} \tab 27 \tab \code{DVLBottomTrack} \cr
   \code{0x1c} \tab 28 \tab \code{echosounder} \cr
   \code{0x1d} \tab 29 \tab \code{DVLWaterTrack} \cr
   \code{0x1e} \tab 30 \tab \code{altimeter} \cr
   \code{0x1f} \tab 31 \tab \code{averageAltimeter} \cr
   \code{0x23} \tab 35 \tab \code{echosounderRaw} \cr
   \code{0xa0} \tab 160 \tab \code{text} \cr
}
}
\examples{
stopifnot(ad2cpCodeToName(0x15) == "0x15=burst")

}
\references{
Nortek AS. \dQuote{Signature Integration 55|250|500|1000kHz.} Nortek AS,
March 31, 2022.
}
\seealso{
Other things related to adp data: 
\code{\link{[[,adp-method}},
\code{\link{[[<-,adp-method}},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adp-class}},
\code{\link{adpAd2cpFileTrim}()},
\code{\link{adpConvertRawToNumeric}()},
\code{\link{adpEnsembleAverage}()},
\code{\link{adpFlagPastBoundary}()},
\code{\link{adpRdiFileTrim}()},
\code{\link{adp_rdi.000}},
\code{\link{adp}},
\code{\link{applyMagneticDeclination,adp-method}},
\code{\link{as.adp}()},
\code{\link{beamName}()},
\code{\link{beamToXyzAdpAD2CP}()},
\code{\link{beamToXyzAdp}()},
\code{\link{beamToXyzAdv}()},
\code{\link{beamToXyz}()},
\code{\link{beamUnspreadAdp}()},
\code{\link{binmapAdp}()},
\code{\link{enuToOtherAdp}()},
\code{\link{enuToOther}()},
\code{\link{handleFlags,adp-method}},
\code{\link{is.ad2cp}()},
\code{\link{plot,adp-method}},
\code{\link{read.adp.ad2cp}()},
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{read.aquadopp}()},
\code{\link{rotateAboutZ}()},
\code{\link{setFlags,adp-method}},
\code{\link{subset,adp-method}},
\code{\link{subtractBottomVelocity}()},
\code{\link{summary,adp-method}},
\code{\link{toEnuAdp}()},
\code{\link{toEnu}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnuAdpAD2CP}()},
\code{\link{xyzToEnuAdp}()},
\code{\link{xyzToEnu}()}

Other things related to ad2cp data: 
\code{\link{ad2cpHeaderValue}()},
\code{\link{adpAd2cpFileTrim}()},
\code{\link{is.ad2cp}()},
\code{\link{read.adp.ad2cp}()}
}
\author{
Dan Kelley
}
\concept{things related to ad2cp data}
\concept{things related to adp data}
