% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-s3.R
\name{print.ocf.marginal}
\alias{print.ocf.marginal}
\title{Print Method for ocf.marginal Objects}
\usage{
\method{print}{ocf.marginal}(x, latex = FALSE, ...)
}
\arguments{
\item{x}{An \code{ocf.marginal} object.}

\item{latex}{If \code{TRUE}, prints LATEX code.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Prints an \code{ocf.marginal} object.
}
\description{
Prints an \code{ocf.marginal} object.
}
\details{
Compilation of the LATEX code requires the following packages: \code{booktabs}, \code{float}, \code{adjustbox}. If
standard errors have been estimated, they are printed in parenthesis below each point estimate.
}
\examples{
\donttest{## Generate synthetic data.
set.seed(1986)

data <- generate_ordered_data(100)
sample <- data$sample
Y <- sample$Y
X <- sample[, -1]

## Fit ocf.
forests <- ocf(Y, X)

## Marginal effects at the mean.
me <- marginal_effects(forests, eval = "atmean")
print(me)
print(me, latex = TRUE)

## Add standard errors.
honest_forests <- ocf(Y, X, n.trees = 4000, honesty = TRUE)
honest_me <- marginal_effects(honest_forests, eval = "atmean", inference = TRUE)
print(honest_me, latex = TRUE)}

}
\references{
\itemize{
  \item Di Francesco, R. (2023). Ordered Correlation Forest. arXiv preprint \href{https://arxiv.org/abs/2309.08755}{arXiv:2309.08755}.
}
}
\seealso{
\code{\link{ocf}}, \code{\link{marginal_effects}}.
}
\author{
Riccardo Di Francesco
}
