% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{od_disaggregate}
\alias{od_disaggregate}
\alias{od_split}
\title{Split-up each OD pair into multiple OD pairs based on subpoints/subzones}
\usage{
od_disaggregate(
  od,
  z,
  subzones = NULL,
  subpoints = NULL,
  code_append = "_ag",
  population_column = 3,
  population_per_od = 5,
  keep_ids = TRUE
)

od_split(
  od,
  z,
  subzones = NULL,
  subpoints = NULL,
  code_append = "_ag",
  population_column = 3,
  population_per_od = 5,
  keep_ids = TRUE
)
}
\arguments{
\item{od}{An origin-destination data frame}

\item{z}{Zones representing origins and destinations}

\item{subzones}{Sub-zones within the zones defining the OD data}

\item{subpoints}{Points within the zones defining the OD data}

\item{code_append}{The name of the column containing aggregate zone names}

\item{population_column}{The column containing the total population (if it exists)}

\item{population_per_od}{Minimum number to assign per OD pair}

\item{keep_ids}{Should the origin and destination ids be kept?
\code{TRUE} by default, meaning 2 extra columns are appended, with the
names \code{o_agg} and \code{d_agg} containing IDs from the original OD data.}
}
\description{
This function is for splitting-up OD pairs.
It increases the number of rows in an OD dataset, while aiming
to keep the amount of travel represented in the data the same.
To take an analogy from another package, it's roughly equivalent
to \href{https://tidyr.tidyverse.org/reference/pivot_longer.html}{\code{tidyr::pivot_longer()}}.
}
\details{
An alias for the function is \code{od_split()}.
}
\examples{
od = od_data_df[1:2, ]
zones = od::od_data_zones_min
subzones = od_data_zones_small
od_disag = od_disaggregate(od, zones, subzones)
ncol(od_disag) -1 == ncol(od) # same number of columns (except disag data gained geometry)
sum(od_disag[[3]]) == sum(od[[3]])
sum(od_disag[[4]]) == sum(od[[4]])
od_sf = od_to_sf(od, zones)
plot(od_data_zones_small$geometry)
plot(od_data_zones_min$geometry, lwd = 3, col = NULL, add = TRUE)
plot(od_sf["all"], add = TRUE)
plot(od_disag["all"], add = TRUE)

# with buildings data
od_disag_buildings = od_disaggregate(od, zones, od_data_buildings)
summary(od_disag_buildings)
plot(od_disag_buildings)
}
