% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.1.111m.R
\name{power.1.111m}
\alias{power.1.111m}
\title{Budget and/or sample size, power, MDES calculation for single-level
    randomized controlled trials (RCTs) investigating
    moderation effects  (1-1-1m)}
\usage{
power.1.111m(
  cost.model = TRUE,
  expr = NULL,
  constraint = NULL,
  sig.level = 0.05,
  two.tailed = TRUE,
  gamma = NULL,
  binary = TRUE,
  power = NULL,
  m = NULL,
  n = NULL,
  p = NULL,
  Q = 0.5,
  c1 = NULL,
  c1t = NULL,
  r.yx = 0,
  r.mx = 0,
  r.ym = 0,
  q.mod = 1,
  gammalim = c(0.005, 5),
  powerlim = c(1e-04, 0.9999),
  nlim = c(20, 1e+07),
  mlim = NULL
)
}
\arguments{
\item{cost.model}{Logical; power analyses accommodating costs and budget
(e.g., required budget for a desired power, power under fixed budget)
if TRUE. Otherwise, conventional power analyses are performed
(e.g., required sample size and power calculation); default value is TRUE.}

\item{expr}{Returned object from function \code{\link{od.1.111m}}; default value is NULL;
if \code{expr} is specified, parameter values of \code{a}, \code{b},
\code{c}, \code{ct}, and \code{p}
used or solved in function \code{\link{od.1.111m}} will
be passed to the current function;
only the values of \code{p} that specified or solved in
function \code{\link{od.1.111m}} can be overwritten
if \code{constraint} is specified.}

\item{constraint}{If specified, the constrained value of
\code{p} in a list format (e.g., constraint = list(p = 0.5))
will overwrite that
from \code{expr}; default value is NULL.}

\item{sig.level}{Significance level, default value is .05.}

\item{two.tailed}{Logical; two-tailed tests if TRUE,
otherwise one-tailed tests; default value is TRUE.}

\item{gamma}{Moderated treatment effect.}

\item{binary}{Logical. The moderator is binary if TRUE and continuous if
FALSE. Default is TRUE.}

\item{power}{Statistical power.}

\item{m}{Total budget.}

\item{n}{Total number of individuals.}

\item{p}{The proportion of individuals assigned to the experimental group.}

\item{Q}{The proportion of individuals in one group the binary moderator.
Default value is 0.5, which requires the minimum number of individuals
to achieve a targeted power. Change it as necessary.}

\item{c1}{The cost of sampling one unit in control condition.}

\item{c1t}{The cost of sampling one unit in treatment condition.}

\item{r.yx}{Within-treatment correlation between the outcome (y) and
the covariate (x) for continuous moderators. Within-treatment
within-moderator correlation between the outcome (y) and
the covariate (x) for binary moderators.}

\item{r.mx}{Within-treatment correlation between the moderator (m) and
the covariate (x), if specified, for continuous moderators.}

\item{r.ym}{Within-treatment correlation between the outcome (y) and
the moderator (m), if specified, for continuous moderators.}

\item{q.mod}{The number of covariates in the moderation model (besides the
treatment, moderator, and their interaction term). The default value is 1.}

\item{gammalim}{The range for identifying the root of moderation
effect size (\code{gamma}) numerically,
default value is c(0.005, 5).}

\item{powerlim}{The range for identifying the root of power
(\code{power}) numerically,
default value is c(0.0001, 0.9999).}

\item{nlim}{The range for identifying the root of sample size (\code{n})
numerically. Default is c(20, 1e7).}

\item{mlim}{The range for identifying the root of budget (\code{m}) numerically,
default value is the costs sampling \code{nlim} units.}
}
\value{
Required budget (\code{m}) or required sample size (\code{n}),
    statistical power(\code{power}),
    minimum detectable moderation effect size (\code{gamma}),
    depending on the specification of parameters.
    The function also returns the function name, design type,
    and parameters used in the calculation.
}
\description{
This function can calculate required budget for desired power,
    the minimum detectable effect size, and
    statistical power under a fixed budget in
    randomized controlled trials (RCTs) probing moderation effects.
    It also can perform conventional power analyses
    (e.g., required sample size calculation, minimum detectable effect size
    calculation, and power calculation).
}
\examples{
# Optimal design and power analyses accommodating costs and budget
myod <- od.1.111m(d =.1, gamma = .2, r12 = .50,
                 c1 = 10, c1t = 100)
myod
N <- power.1.111m(expr = myod, power = .8)
N$out

# Conventional power analyses
# Required sample size for a binary moderator
N <- power.1.111m(cost.model = FALSE, gamma = .2, power = .8, p =.5)
N

# Required sample size for a continuous moderator
N <- power.1.111m(cost.model = FALSE,
                  gamma = .2, power = .8, p =.5, binary = FALSE)
N

}
