% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dwishart_cpp}
\alias{dwishart_cpp}
\title{Compute density of (Inverse-) Wishart distribution}
\usage{
dwishart_cpp(x, df, scale, log = FALSE, inv = FALSE)
}
\arguments{
\item{x}{A \code{matrix}, a covariance matrix of dimension \code{p} x \code{p}.}

\item{df}{An \code{integer}, the degrees of freedom.
Must be greater or equal \code{p}.}

\item{scale}{A \code{matrix}, the scale matrix of dimension \code{p} x \code{p}.
Must be a covariance matrix.}

\item{log}{A \code{logical}, if \code{TRUE} the logarithm of the density value is
returned.
By default, \code{log = FALSE}.}

\item{inv}{A \code{logical}, if \code{TRUE} the density of the Inverse-Wishart
distribution is returned.
By default, \code{inv = FALSE}.}
}
\value{
A \code{numeric}, the density value.
}
\description{
This function computes the density of the (Inverse-) Wishart distribution.
}
\details{
This function performs no input checks. See \code{\link{dwishart}}
for the version with input checks.
}
\keyword{internal}
