% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert_vector_entry.R
\name{insert_vector_entry}
\alias{insert_vector_entry}
\title{Insert entry in vector}
\usage{
insert_vector_entry(v, x, p)
}
\arguments{
\item{v}{A \code{vector}.}

\item{x}{A single value (i.e., an \code{atomic} \code{vector} of length 1), the entry
to be added.}

\item{p}{An \code{integer}, the position where to add the entry:
\itemize{
\item \code{p = 0} appends the value left
\item \code{p = length(v)} appends the value right
\item \code{p = n} inserts the value between the \code{n}-th and
\code{(n + 1)}-th entry of \code{v}.
}

Can also be a \code{vector} of multiple positions.}
}
\value{
A \code{vector}.
}
\description{
This function inserts a value into a vector.
}
\examples{
v <- 1:3
x <- 0
insert_vector_entry(v, x, 0)
insert_vector_entry(v, x, 1)
insert_vector_entry(v, x, 2)
insert_vector_entry(v, x, 3)

### also multiple positions
insert_vector_entry(v, x, 0:3)

### also trivial case
insert_vector_entry(integer(), integer(), integer())
}
