% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rmvnorm_cpp}
\alias{rmvnorm_cpp}
\title{Draw from multivariate normal distribution}
\usage{
rmvnorm_cpp(mean, Sigma, log = FALSE)
}
\arguments{
\item{mean}{A \code{numeric}, the mean vector of length \code{p}.}

\item{Sigma}{A \code{matrix}, the covariance matrix of dimension \code{p} x \code{p}.}

\item{log}{A \code{logical}, if \code{TRUE} the draw is taken from the log-normal
distribution.
By default, \code{log = FALSE}.}
}
\value{
A column vector of length \code{p}, the random draw.
}
\description{
This function draws from a multivariate normal distribution.
}
\details{
The function builds upon the following fact:
If \eqn{\epsilon = (\epsilon_1,\dots,\epsilon_p)},
where each \eqn{\epsilon_i} is drawn independently from a standard normal
distribution, then \eqn{\mu + L\epsilon} is a draw from the \eqn{p}-variate
normal distribution \eqn{N(\mu,\Sigma)}, where \eqn{L} is the lower
triangular factor of the Choleski decomposition of \eqn{\Sigma}.

This function performs no input checks. See \code{\link{rmvnorm}}
for the version with input checks.
}
\keyword{internal}
