% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_block_objects.R
\name{block_list}
\alias{block_list}
\title{Create paragraph blocks}
\usage{
block_list(...)
}
\arguments{
\item{...}{a list of objects of class \code{\link{fpar}} or
\code{flextable}. When output is only for Word, objects
of class \code{\link{external_img}} can also be used in
fpar construction to mix text and images in a single paragraph.}
}
\description{
a list of blocks can be used to gather
several blocks (paragraphs or tables) into a single
object. The function is to be used when adding
footnotes or formatted paragraphs into a new slide.
}
\examples{

#' # block list ------

img.file <- file.path( R.home("doc"), "html", "logo.jpg" )
fpt_blue_bold <- fp_text(color = "#006699", bold = TRUE)
fpt_red_italic <- fp_text(color = "#C32900", italic = TRUE)


## This can be only be used in a MS word output as pptx does
## not support paragraphs made of text and images.
## (actually it can be used but image will not appear in the
## pptx output)
value <- block_list(
  fpar(ftext("hello world", fpt_blue_bold)),
  fpar(ftext("hello", fpt_blue_bold), " ",
       ftext("world", fpt_red_italic)),
  fpar(
    ftext("hello world", fpt_red_italic),
          external_img(
            src = img.file, height = 1.06, width = 1.39)))
value

doc <- read_docx()
doc <- body_add(doc, value)
print(doc, target = tempfile(fileext = ".docx"))


value <- block_list(
  fpar(ftext("hello world", fpt_blue_bold)),
  fpar(ftext("hello", fpt_blue_bold), " ",
       ftext("world", fpt_red_italic)),
  fpar(
    ftext("blah blah blah", fpt_red_italic)))
value

doc <- read_pptx()
doc <- add_slide(doc)
doc <- ph_with(doc, value, location = ph_location_type(type = "body"))
print(doc, target = tempfile(fileext = ".pptx"))


}
\seealso{
\code{\link[=ph_with]{ph_with()}}, \code{\link[=body_add]{body_add()}}

Other block functions for reporting: 
\code{\link{block_caption}()},
\code{\link{block_pour_docx}()},
\code{\link{block_section}()},
\code{\link{block_table}()},
\code{\link{block_toc}()},
\code{\link{fpar}()},
\code{\link{plot_instr}()},
\code{\link{unordered_list}()}
}
\concept{block functions for reporting}
