% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_manipulate.R
\name{ph_remove}
\alias{ph_remove}
\title{remove a shape}
\usage{
ph_remove(x, type = "body", id = 1, ph_label = NULL, id_chr = NULL)
}
\arguments{
\item{x}{an rpptx object}

\item{type}{placeholder type}

\item{id}{placeholder index (integer) for a duplicated type. This is to be used when a placeholder
type is not unique in the layout of the current slide, e.g. two placeholders with type 'body'. To
add onto the first, use \code{id = 1} and \code{id = 2} for the second one.
Values can be read from \code{\link{slide_summary}}.}

\item{ph_label}{label associated to the placeholder. Use column
\code{ph_label} of result returned by \code{\link{slide_summary}}.}

\item{id_chr}{deprecated.}
}
\description{
remove a shape in a slide
}
\examples{
fileout <- tempfile(fileext = ".pptx")
dummy_fun <- function(doc){
  doc <- add_slide(doc, layout = "Two Content",
    master = "Office Theme")
  doc <- ph_with(x = doc, value = "Un titre",
    location = ph_location_type(type = "title"))
  doc <- ph_with(x = doc, value = "Un corps 1",
    location = ph_location_type(type = "body", id = 1))
  doc <- ph_with(x = doc, value = "Un corps 2",
    location = ph_location_type(type = "body", id = 2))
  doc
}
doc <- read_pptx()
for(i in 1:3)
  doc <- dummy_fun(doc)

doc <- on_slide(doc, index = 1)
doc <- ph_remove(x = doc, type = "title")

doc <- on_slide(doc, index = 2)
doc <- ph_remove(x = doc, type = "body", id = 2)

doc <- on_slide(doc, index = 3)
doc <- ph_remove(x = doc, type = "body", id = 1)

print(doc, target = fileout )
}
\seealso{
\code{\link{ph_with}}

Other functions for placeholders manipulation: \code{\link{ph_hyperlink}},
  \code{\link{ph_slidelink}}
}
\concept{functions for placeholders manipulation}
