% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pptx_informations.R
\name{slide_summary}
\alias{slide_summary}
\title{get PowerPoint slide content in a data.frame}
\usage{
slide_summary(x, index = NULL)
}
\arguments{
\item{x}{an rpptx object}

\item{index}{slide index}
}
\description{
get content and positions of current slide
into a data.frame. Data for any tables, images, or paragraphs are
imported into the resulting data.frame.
}
\note{
The column \code{id} of the result is not to be used by users.
This is a technical string id whose value will be used by office
when the document will be rendered. This is not related to argument
\code{index} required by functions \code{ph_with}.
}
\examples{
my_pres <- read_pptx()
my_pres <- add_slide(my_pres)
my_pres <- ph_with(my_pres, format(Sys.Date()),
  location = ph_location_type(type="dt"))
my_pres <- add_slide(my_pres)
my_pres <- ph_with(my_pres, iris[1:2,],
  location = ph_location_type(type="body"))
slide_summary(my_pres)
slide_summary(my_pres, index = 1)
}
\seealso{
Other functions for reading presentation informations: \code{\link{annotate_base}},
  \code{\link{color_scheme}},
  \code{\link{layout_properties}},
  \code{\link{layout_summary}}, \code{\link{length.rpptx}},
  \code{\link{slide_size}}
}
\concept{functions for reading presentation informations}
