% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_docx.R
\name{change_styles}
\alias{change_styles}
\title{replace paragraphs styles}
\usage{
change_styles(x, mapstyles)
}
\arguments{
\item{x}{an rdocx object}

\item{mapstyles}{a named list, names are the replacement style,
content (as a character vector) are the styles to be replaced.}
}
\description{
Replace styles with others in a Word document.
}
\examples{
library(magrittr)

mapstyles <- list( "centered" = c("Normal"),
    "heading 3" = c("heading 1", "heading 2") )
doc <- read_docx() \%>\%
  body_add_par("A title", style = "heading 1") \%>\%
  body_add_par("Another title", style = "heading 2") \%>\%
  body_add_par("Hello world!", style = "Normal") \%>\%
  change_styles( mapstyles = mapstyles )

print(doc, target = tempfile(fileext = ".docx"))
}
