% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_rate_info.R
\name{prep_rate}
\alias{prep_rate}
\title{Create data of input rate information for a single input}
\usage{
prep_rate(
  plot_info,
  gc_rate,
  unit,
  rates = NULL,
  min_rate = NA,
  max_rate = NA,
  num_rates = 5,
  design_type = NA,
  rank_seq_ws = NULL,
  rank_seq_as = NULL,
  rate_jump_threshold = NA
)
}
\arguments{
\item{plot_info}{(data.frame) plot information created by make_input_plot_data}

\item{gc_rate}{(numeric) Input rate the grower would have chosen if not running an experiment. This rate is assigned to the non-experiment part of the field. This rate also becomes one of the trial input rates unless you specify the trial rates directly using rates argument}

\item{unit}{(string) unit of input}

\item{rates}{(numeric vector) Default is NULL. Sequence of trial rates in the ascending order.}

\item{min_rate}{(numeric) minimum input rate. Ignored if rates are specified.}

\item{max_rate}{(numeric) maximum input rate. Ignored if rates are specified}

\item{num_rates}{(numeric) Default is 5. It has to be an even number if design_type is "ejca". Ignored if rates are specified.}

\item{design_type}{(string) type of trial design. available options are Latin Square ("ls"), Strip ("str"), Randomized Strip ("rstr"), Randomized Block ("rb"), Sparse ("sparse"), and Extra Jump-conscious Alternate "ejca". See the article on trial design for more details.}

\item{rank_seq_ws}{(integer) vector of integers indicating the order of the ranking of the rates, which will be repeated "within" a strip.}

\item{rank_seq_as}{(integer) vector of integers indicating the order of the ranking of the rates, which will be repeated "across" strip for their first plots.}

\item{rate_jump_threshold}{(integer) highest jump in rate rank acceptable}
}
\value{
data.frame of input rate information
}
\description{
Create data of input rate information for a single input with some checks on the validity of the information provided by the user. This can be used to assign rates to experiment plots using assign_rates().
}
\examples{
plot_info <-
  prep_plot(
    input_name = "seed",
    unit_system = "imperial",
    machine_width = 60,
    section_num = 24,
    harvester_width = 30,
    plot_width = 30
  )

prep_rate(
  plot_info,
  gc_rate = 30000,
  unit = "seeds",
  rates = c(20000, 25000, 30000, 35000, 40000)
)
}
