% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert.r
\name{insert}
\alias{insert}
\title{Insert values into a vector}
\usage{
insert(x, into, at, warn = TRUE)
}
\arguments{
\item{x}{Vector of values to insert.}

\item{into}{vector of values into which to insert \code{x}.}

\item{at}{Vector of positions (indices) where \code{x} should be inserted. If the length of \code{x} is shorter than the length of \code{at}, then values in \code{x} will be recycled and a warning produced.}

\item{warn}{If \code{TRUE}, provide warnings.}
}
\value{
Vector.
}
\description{
This function inserts values into a vector, lengthening the overall vector. It is different from, say, \code{x[1:3] <- c('a', 'b', 'c')} which simply replaces the values at indices 1 through 3.
}
\examples{

x <- -1:-3
into <- 10:20
at <- c(1, 3, 14)
insert(x, into, at)

insert(-1, into, at)

}
\seealso{
\code{\link{insertCol}}, \code{\link{insertRow}}
}
