% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockDrugExposure.R
\name{mockDrugExposure}
\alias{mockDrugExposure}
\title{Generates a mock drug exposure table and integrates it into an existing CDM object.}
\usage{
mockDrugExposure(cdm, recordPerson = 1, seed = NULL)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object that must already include 'person' and 'observation_period' tables.
This object serves as the base CDM structure where the drug exposure data will be added.
The 'person' and 'observation_period' tables must be populated as they are necessary for generating accurate drug exposure records.}

\item{recordPerson}{An integer specifying the expected number of drug exposure records to generate per person.
This parameter allows for the simulation of varying drug usage frequencies among individuals in the cohort,
reflecting real-world variability in medication administration.}

\item{seed}{An optional integer used to set the seed for random number generation, ensuring reproducibility of the generated data.
If provided, this seed enables the function to produce consistent results each time it is run with the same inputs.
If 'NULL', the seed is not set, which can lead to different outputs on each run.}
}
\value{
Returns the modified \code{cdm} object with the new 'drug_exposure' table added. This table includes the simulated
drug exposure data for each person, ensuring that each record is correctly linked to individuals in the 'person' table
and falls within valid observation periods.
}
\description{
This function simulates drug exposure records for individuals within a specified cohort. It creates a realistic dataset by generating drug exposure records based on the specified number of records per person. Each drug exposure record is correctly associated with an individual within valid observation periods, ensuring the integrity of the data.
}
\examples{
library(omock)

# Create a mock CDM reference and add drug exposure records
cdm <- mockCdmReference() |>
  mockPerson() |>
  mockObservationPeriod() |>
  mockDrugExposure(recordPerson = 3)

# View the generated drug exposure data
print(cdm$drug_exposure)
}
