% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodSettings.R
\name{settings.cohort_table}
\alias{settings.cohort_table}
\title{Get cohort settings from a cohort_table object.}
\usage{
\method{settings}{cohort_table}(x)
}
\arguments{
\item{x}{A cohort_table object.}
}
\value{
A table with the details of the cohort settings.
}
\description{
Get cohort settings from a cohort_table object.
}
\examples{
library(omopgenerics)
library(dplyr, warn.conflicts = FALSE)

person <- tibble(
  person_id = 1, gender_concept_id = 0, year_of_birth = 1990,
  race_concept_id = 0, ethnicity_concept_id = 0
)
observation_period <- tibble(
  observation_period_id = 1, person_id = 1,
  observation_period_start_date = as.Date("2000-01-01"),
  observation_period_end_date = as.Date("2023-12-31"),
  period_type_concept_id = 0
)
cohort <- tibble(
  cohort_definition_id = 1,
  subject_id = 1,
  cohort_start_date = as.Date("2010-01-01"),
  cohort_end_date = as.Date("2012-01-01")
)
cdm <- cdmFromTables(
  tables = list("person" = person, "observation_period" = observation_period),
  cdmName = "test",
  cohortTables = list("my_cohort" = cohort)
)

settings(cdm$my_cohort)

cdm$my_cohort <- cdm$my_cohort |>
  newCohortTable(cohortSetRef = tibble(
    cohort_definition_id = 1, cohort_name = "new_name"
  ))

settings(cdm$my_cohort)

}
