% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlapping_batches.R
\name{pick_batch_sizes}
\alias{pick_batch_sizes}
\title{Picking optimal batch size values}
\usage{
pick_batch_sizes(input.seq, size = 50, overlap = 15, around = 5)
}
\arguments{
\item{input.seq}{an object of class \code{sequence}.}

\item{size}{The center size around which an optimum is to be searched}

\item{overlap}{The desired overlap between batches}

\item{around}{The range around the center which is maximally allowed
to be searched.}
}
\value{
An integer value for the size which most evenly divides batches. In
case of ties, bigger batch sizes are preferred.
}
\description{
Suggest an optimal batch size value for use in
\code{\link[onemap]{map_overlapping_batches}}
}
\examples{

  LG <- structure(list(seq.num = seq(1,800)), class = "sequence")
  batchsize <- pick_batch_sizes(LG, 50, 19)

}
\seealso{
\code{\link[onemap]{map_overlapping_batches}}
}
\author{
Bastian Schiffthaler, \email{bastian.schiffthaler@umu.se}
}
\keyword{utilities}
