% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{force_compatibility}
\alias{force_compatibility}
\title{Remove alternate/deprecated term IDs and swap for new ones}
\usage{
force_compatibility(ontology, terms, remove_unmatchable = TRUE)
}
\arguments{
\item{ontology}{\code{ontology_index} object.}

\item{terms}{Character vector of ontological terms.}

\item{remove_unmatchable}{Boolean value determining whether to silently remove unmatchable terms. Throws an error if there exist terms which cannot be matched in the ontology, including via `alt_id' fields.}
}
\value{
Character vector of terms which are compatible with the given ontology.
}
\description{
Remove alternate/deprecated term IDs and swap for new ones
}
\examples{
data(hpo)
force_compatibility(hpo, c("HP:0001873","nonsense term"))
}

