% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhpp_functions.R
\name{derivative_KDE}
\alias{derivative_KDE}
\title{Calculate KDE derivative over edges}
\usage{
derivative_KDE(tree.discr, Edge.KDE.stat)
}
\arguments{
\item{tree.discr}{simmap or phylo object. A discretized tree using the 'discr_Simmap' function.}

\item{Edge.KDE.stat}{list. A list with the estimated normalized or loess smoothing KDEs for each edge.}
}
\value{
A list with the distribution of the derivatives calculated for each edge.
}
\description{
Calculates the derivative of the normalized Markov KDE or normalized loess smoothing over edges.
}
\examples{
data("hym_tree", "hym_kde")
# Get reference tree.
tree_discr <- discr_Simmap(hym_tree, res = 200)
# Get smoothing of normalized edge KDE data for mean rates.
Edge_KDE <- hym_kde$head
Edge_KDE_stat <- Edge_KDE$loess.lambda.mean
# Calculate derivatives.
Edge_KDE$loess.lambda.mean.deriv <- derivative_KDE(tree_discr, Edge_KDE_stat)
# Check derivatives of some arbitrary branch.
Edge_KDE$loess.lambda.mean.deriv[[5]]

}
\author{
Sergei Tarasov
}
