% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramo_functions.R
\name{merge_tree_cat}
\alias{merge_tree_cat}
\title{Merge state bins over a tree}
\usage{
merge_tree_cat(tree)
}
\arguments{
\item{tree}{simmap object.}
}
\value{
A tree with merged identical bins.
}
\description{
Merges identical state bins over a tree in the discretized stochastic map.
}
\examples{
data("hym_stm")
tree <- hym_stm[[1]][[1]]
tree <- discr_Simmap(tree, res = 100)
stm_merg <- merge_tree_cat(tree)
# Check some arbitrary branch.
br1 <- tree$maps[[5]]
br1
br2 <- stm_merg$maps[[5]]
br2
sum(br1) == br2

}
\author{
Sergei Tarasov
}
