% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhpp_functions.R
\name{posterior_lambda_KDE}
\alias{posterior_lambda_KDE}
\title{Get analytical posterior}
\usage{
posterior_lambda_KDE(tree.list)
}
\arguments{
\item{tree.list}{multiSimmap object.}
}
\value{
A list with mean ($Mean), standard deviation ($SD), and 95HPD interval ($Q_2.5 and $Q_97.5) calculated for the posterior distribution.
}
\description{
Calculates the required statitics for the posterior distribution of number of state changes across all branches of all trees.
}
\examples{
data("hym_stm_amalg")
# Get a sample of ten stochastic maps from head.
tree_list <- hym_stm_amalg$head
tree_list <- merge_tree_cat_list(tree_list[1:10])
# Calculate posterior poisson statistics.
posterior_lambda_KDE(tree_list)

}
\author{
Sergei Tarasov
}
