% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vxapply.R
\name{loapply}
\alias{loapply}
\title{Specialised lapply for objects}
\usage{
loapply(X, FUN, ...)
}
\arguments{
\item{X, ...}{See \link{lapply}}

\item{FUN}{Either a function to apply to each element of \code{X}, as in \link{lapply}
or the field/method name of an OOP object (see examples)}
}
\description{
Specialised \code{lapply} functions for R6 or other OOP classes.
This is simply a wrapper that detects if \code{FUN} is a function, in which
case \code{lapply} is used as usual, or a string, in which case the given
field/method is returned as a list.
}
\examples{
## lapply as usual
loapply(c(1, 2, 3), identity)

## For R6 objects
objs <- list(ooplah$new(), ooplah$new())
# Public field
loapply(objs, "oop")
# Public method
loapply(objs, "hello")
}
