% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.admin.r
\name{dsadmin.package_descriptions}
\alias{dsadmin.package_descriptions}
\title{Get DataSHIELD package descriptions}
\usage{
dsadmin.package_descriptions(opal, fields = NULL, df = TRUE)
}
\arguments{
\item{opal}{Opal object or list of opal objects.}

\item{fields}{A character vector giving the fields to extract from each package's DESCRIPTION file in addition to the default ones, or NULL (default). Unavailable fields result in NA values.}

\item{df}{Return a data.frame (default is TRUE)}
}
\value{
The DataSHIELD package descriptions as a data.frame or a list
}
\description{
Get DataSHIELD package descriptions
}
\examples{
\dontrun{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
dsadmin.package_descriptions(o)
opal.logout(o)
}
}
\seealso{
Other DataSHIELD functions: 
\code{\link{dsadmin.get_methods}()},
\code{\link{dsadmin.get_method}()},
\code{\link{dsadmin.get_options}()},
\code{\link{dsadmin.install_package}()},
\code{\link{dsadmin.installed_package}()},
\code{\link{dsadmin.package_description}()},
\code{\link{dsadmin.remove_package}()},
\code{\link{dsadmin.rm_methods}()},
\code{\link{dsadmin.rm_method}()},
\code{\link{dsadmin.rm_option}()},
\code{\link{dsadmin.rm_package_methods}()},
\code{\link{dsadmin.set_method}()},
\code{\link{dsadmin.set_option}()},
\code{\link{dsadmin.set_package_methods}()}
}
\concept{DataSHIELD functions}
