% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary.annotations.R
\name{harmo.annotate.status}
\alias{harmo.annotate.status}
\title{Set variable annotation with Harmonization Status term (deprecated)}
\usage{
harmo.annotate.status(tibble, variables = NULL, status)
}
\arguments{
\item{tibble}{Tibble to be annotated.}

\item{variables}{A character vector of variable names to be annotated. If NULL or empty, all
the columns of the tibble will be annotated.}

\item{status}{The harmonization status to apply: 'complete', 'undetermined', 'impossible' or 'na'. If NULL, the annotation will be deleted.}
}
\value{
The annotated tibble
}
\description{
Deprecated: use \link{dictionary.annotate.harmo_status} instead.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
cqx <- opal.table_get(o, "CPTP", "Cag_coreqx")
cqx <- dictionary.annotate.harmo_status(cqx, 
  variables = c("A_SDC_EDU_LEVEL", "A_SDC_EDU_LEVEL_AGE"), 
  status = "complete")
opal.logout(o)
}
}
