% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.r
\name{opal.get}
\alias{opal.get}
\title{Generic REST resource getter.}
\usage{
opal.get(opal, ..., query = list(), callback = NULL)
}
\arguments{
\item{opal}{Opal object.}

\item{...}{Resource path segments.}

\item{query}{Named list of query parameters.}

\item{callback}{A callback function to handle the response object.}
}
\description{
Generic REST resource getter.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.get(o, 'project', 'datashield')
opal.logout(o)
}
}
\seealso{
Other REST functions: 
\code{\link{opal.delete}()},
\code{\link{opal.post}()},
\code{\link{opal.put}()}
}
\concept{REST functions}
