% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.table.R
\name{opal.table_view_update}
\alias{opal.table_view_update}
\title{Update the table references and the entity filter of an Opal view}
\usage{
opal.table_view_update(opal, project, table, tables = NULL, where = NULL)
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{Project name where the table will be located.}

\item{table}{Table name to be created.}

\item{tables}{List of the fully qualified table names that are referred by the view. Not modified when NULL (default).}

\item{where}{The entity filter script. Not modified when NULL (default). To remove the filter, set an empty string.}
}
\description{
Update the table references and/or the entity filter of an existing Opal view. The view
dictionary will NOT be modified (use \link{opal.table_dictionary_update} to
apply a dictionary).
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
# make a view
opal.table_view_create(o, "CNSIM", "CNSIM123",
                       c("CNSIM.CNSIM1"))

# update the table references
opal.table_view_update(o, "CNSIM", "CNSIM123",
                       tables = c("CNSIM.CNSIM1", "CNSIM.CNSIM2", "CNSIM.CNSIM3"))

# update the entity filter
opal.table_view_update(o, "CNSIM", "CNSIM123", where = "$('LAB_TSC').ge(5)")

# remove the entity filter
opal.table_view_update(o, "CNSIM", "CNSIM123", where = "")

# update both the table references and the entity filter
opal.table_view_update(o, "CNSIM", "CNSIM123",
                       tables = c("CNSIM.CNSIM1", "CNSIM.CNSIM2", "CNSIM.CNSIM3"),
                       where = "$('LAB_TSC').ge(5)")
opal.logout(o)
}
}
\seealso{
Other table functions: 
\code{\link{opal.resource_view_create}()},
\code{\link{opal.resource_view_reconnect}()},
\code{\link{opal.table_create}()},
\code{\link{opal.table_delete}()},
\code{\link{opal.table_dictionary_get}()},
\code{\link{opal.table_dictionary_update}()},
\code{\link{opal.table_exists}()},
\code{\link{opal.table_export}()},
\code{\link{opal.table_get}()},
\code{\link{opal.table_import}()},
\code{\link{opal.table_perm_add}()},
\code{\link{opal.table_perm_delete}()},
\code{\link{opal.table_perm}()},
\code{\link{opal.table_save}()},
\code{\link{opal.table_truncate}()},
\code{\link{opal.table_view_create}()}
}
\concept{table functions}
