/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import opennlp.tools.util.Heap;

public class ListHeap
implements Heap {
    private List list;
    private Comparator comp;
    private int size;
    private Object max = null;

    public ListHeap(int sz, Comparator c) {
        this.size = sz;
        this.comp = c;
        this.list = new ArrayList(sz);
    }

    public ListHeap(int sz) {
        this(sz, null);
    }

    private int parent(int i) {
        return (i - 1) / 2;
    }

    private int left(int i) {
        return (i + 1) * 2 - 1;
    }

    private int right(int i) {
        return (i + 1) * 2;
    }

    public int size() {
        return this.list.size();
    }

    private void swap(int x, int y) {
        Object ox = this.list.get(x);
        Object oy = this.list.get(y);
        this.list.set(y, ox);
        this.list.set(x, oy);
    }

    private boolean lt(Object o1, Object o2) {
        if (this.comp != null) {
            return this.comp.compare(o1, o2) < 0;
        }
        return ((Comparable)o1).compareTo(o2) < 0;
    }

    private boolean gt(Object o1, Object o2) {
        if (this.comp != null) {
            return this.comp.compare(o1, o2) > 0;
        }
        return ((Comparable)o1).compareTo(o2) > 0;
    }

    private void heapify(int i) {
        while (true) {
            int l = this.left(i);
            int r = this.right(i);
            int smallest = l < this.list.size() && this.lt(this.list.get(l), this.list.get(i)) ? l : i;
            if (r < this.list.size() && this.lt(this.list.get(r), this.list.get(smallest))) {
                smallest = r;
            }
            if (smallest == i) break;
            this.swap(smallest, i);
            i = smallest;
        }
    }

    public Object extract() {
        if (this.list.size() == 0) {
            throw new RuntimeException("Heap Underflow");
        }
        Object top = this.list.get(0);
        int last = this.list.size() - 1;
        if (last != 0) {
            this.list.set(0, this.list.remove(last));
            this.heapify(0);
        } else {
            this.list.remove(last);
        }
        return top;
    }

    public void setSize() {
        this.setSize(this.size);
    }

    public void setSize(int sz) {
        if (sz > this.list.size()) {
            return;
        }
        ArrayList<Object> t = new ArrayList<Object>(sz);
        for (int i = 0; i < sz; ++i) {
            t.add(this.extract());
        }
        this.list = t;
    }

    public Object top() {
        if (this.list.size() == 0) {
            throw new RuntimeException("Heap Underflow");
        }
        return this.list.get(0);
    }

    public void add(Object o) {
        if (this.max == null) {
            this.max = o;
        } else if (this.gt(o, this.max)) {
            if (this.list.size() < this.size) {
                this.max = o;
            } else {
                return;
            }
        }
        this.list.add(o);
        int i = this.list.size() - 1;
        while (i > 0 && this.gt(this.list.get(this.parent(i)), o)) {
            this.list.set(i, this.list.get(this.parent(i)));
            i = this.parent(i);
        }
        this.list.set(i, o);
    }

    public void clear() {
        this.list.clear();
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public static void main(String[] args) {
        ListHeap heap = new ListHeap(5);
        for (int ai = 0; ai < args.length; ++ai) {
            heap.add(new Integer(Integer.parseInt(args[ai])));
        }
        while (!heap.isEmpty()) {
            System.out.print(heap.extract() + " ");
        }
        System.out.println();
    }
}

