% Generated by roxygen2 (4.0.1): do not edit by hand
\name{trendLevel}
\alias{trendLevel}
\alias{trendLevelHour}
\alias{trendLevelWd}
\title{trendLevel}
\usage{
trendLevel(mydata, pollutant = "nox", x = "month", y = "hour",
  type = "year", rotate.axis = c(90, 0), n.levels = c(10, 10, 4),
  limits = c(0, 100), cols = "default", auto.text = TRUE,
  key.header = "use.stat.name", key.footer = pollutant,
  key.position = "right", key = TRUE, statistic = c("mean", "max",
  "frequency"), stat.args = NULL, stat.safe.mode = TRUE,
  drop.unused.types = TRUE, ...)
}
\arguments{
\item{mydata}{The openair data frame to use to generate the
\code{trendLevel} plot.}

\item{pollutant}{The name of the data series in \code{mydata} to sample to
produce the \code{trendLevel} plot.}

\item{x}{The name of the data series to use as the \code{trendLevel}
x-axis. This is used with the \code{y} and \code{type} options to bin the
data before applying \code{statistic} (see below). Allowed options
currently include \dQuote{hour}, \dQuote{month}, \dQuote{year}, and
\dQuote{wd}. Other data series in \code{mydata} can also be used. (Note:
\code{trendLevel} does not allow duplication in \code{x}, \code{y} and
\code{type} options within a call.)}

\item{y,type}{The names of the data series to use as the \code{trendLevel}
y-axis and for additional conditioning, respectively. As \code{x} above.}

\item{rotate.axis}{The rotation to be applied to \code{trendLevel} \code{x}
and \code{y} axes. The default, \code{c(90, 0)}, rotates the x axis by 90
degrees but does not rotate the y axis. (Note: If only one value is
supplied, this is applied to both axes; if more than two values are
supplied, only the first two are used.)}

\item{n.levels}{The number of levels to split \code{x}, \code{y} and
\code{type} data into if numeric. The default, \code{c(10, 10, 4)}, cuts
numeric \code{x} and \code{y} data into ten levels and numeric
\code{type} data into four levels. (Notes: This option is ignored for
date conditioning and factors.  If less than three values are supplied,
three values are determined by recursion; if more than three values are
supplied, only the first three are used.)}

\item{limits}{The colour scale range to use when generating the
\code{trendLevel} plot.}

\item{cols}{The colour set to use to colour the \code{trendLevel} surface.
\code{cols} is passed to \code{openColours} for evaluation. See
\code{?openColours} for more details.}

\item{auto.text}{Automatic routine text formatting. \code{auto.text = TRUE}
passes common \code{lattice} labelling terms (e.g. \code{xlab} for the
x-axis, \code{ylab} for the y-axis and \code{main} for the title) to the
plot via \code{quickText} to provide common text formatting.  The
alternative \code{auto.text = FALSE} turns this option off and passes any
supplied labels to the plot without modification.}

\item{key.header,key.footer}{Adds additional text labels above and/or below
the scale key, respectively. For example, passing the options
\code{key.header = "", key.footer = c("mean","nox")} adds the addition
text as a scale footer. If enabled (\code{auto.text = TRUE}), these
arguments are passed to the scale key (\code{drawOpenKey}) via
\code{quickText} to handle formatting. The term \code{"get.stat.name"},
used as the default \code{key.header} setting, is reserved and
automatically adds statistic function names or defaults to \code{"level"}
when unnamed functions are requested via \code{statistic}.}

\item{key.position}{Location where the scale key should be plotted.
Allowed arguments currently include \dQuote{top}, \dQuote{right},
\dQuote{bottom} and \dQuote{left}.}

\item{key}{Fine control of the scale key via \code{drawOpenKey}. See
\code{?drawOpenKey} for further details.}

\item{statistic}{The statistic method to be use to summarise locally binned
\code{pollutant} measurements with. Three options are currently encoded:
\dQuote{mean} (default), \dQuote{max} and \dQuote{frequency}. (Note:
Functions can also be sent directly via \code{statistic}.  However, this
option is still in development and should be used with caution. See
Details below.)}

\item{stat.args}{Additional options to be used with \code{statistic} if
this is a function. The extra options should be supplied as a list of
named parameters. (see Details below.)}

\item{stat.safe.mode}{An addition protection applied when using functions
direclty with \code{statistic} that most users can ignore. This option
returns \code{NA} instead of running \code{statistic} on binned
subsamples that are empty. Many common functions terminate with an error
meassage when applied to an empty dataset. So, this options provides a
mechanism to work with such functions. For a very few cases, e.g. for a
function that counted missing entries, it might need to be set to
\code{FALSE} (see Details below.)}

\item{drop.unused.types}{Hide unused/empty \code{type} conditioning cases.
Some conditioning options may generate empty cases for some data sets,
e.g. a hour of the day when no measurements were taken. Empty \code{x}
and \code{y} cases generate 'holes' in individual plots. However, empty
\code{type} cases would produce blank panels if plotted. Therefore, the
default, \code{TRUE}, excludes these empty panels from the plot. The
alternative \code{FALSE} plots all \code{type} panels.}

\item{...}{Addition options are passed on to \code{cutData} for
\code{type} handling and \code{levelplot} in \code{lattice} for finer
control of the plot itself.}
}
\value{
As well as generating the plot itself, \code{trendLevel} also
  returns an object of class ``openair''. The object includes three main
  components: \code{call}, the command used to generate the plot;
  \code{data}, the data frame of summarised information used to make the
  plot; and \code{plot}, the plot itself. If retained, e.g. using
  \code{output <- trendLevel(mydata)}, this output can be used to recover
  the data, reproduce or rework the original plot or undertake further
  analysis.

An openair output can be manipulated using a number of generic operations,
  including \code{print}, \code{plot} and \code{summary}.

Summary statistics can also be extracted directly using \code{results},
  e.g.  \code{results(object)} for \code{output <- trendLevel(mydata)}.
}
\description{
The trendLevel function provides a way of rapidly showing a large amount of
data in a condensed form. In one plot, the variation in the concentration
of one pollutant can to shown as a function of three other properties. The
default version of the plot uses y = time of day, x = month of year and
type = year to provide information on trends, seasonal effects and diurnal
variations. However, x, y and type and summarising statistics can all be
modified to provide a range of other similar plots.
}
\details{
\code{trendLevel} allows the use of third party summarising functions via
the \code{statistic} option. Any additional function arguments not included
within a function called using \code{statistic} should be supplied as a
list of named parameters and sent using \code{stat.args}. For example, the
encoded option \code{statistic = "mean"} is equivalent to \code{statistic =
mean, stat.args = list(na.rm = TRUE)} or the R command \code{mean(x, na.rm=
TRUE)}.  Many R functions and user`s own code could be applied in a similar
fashion, subject to the following restrictions: the first argument sent to
the function must be the data series to be analysed; the name `x' cannot be
used for any of the extra options supplied in \code{stat.args}; and the
function should return the required answer as a numeric or NA. Note: If the
supplied function returns more than one answer, currently only the first of
these is retained and used by \code{trendLevel}. All other returned
information will be ignored without warning. If the function terminates
with an error when it is sent an empty data series, the option
\code{stat.safe.mode} should not be set to \code{FALSE} or
\code{trendLevel} may fail. Note: The \code{stat.safe.mode = TRUE} option
returns an NA without warning for empty data series.
}
\examples{
#basic use
#default statistic = "mean"
trendLevel(mydata, pollutant = "nox")

#applying same as 'own' statistic
my.mean <- function(x) mean(x, na.rm = TRUE)
trendLevel(mydata, pollutant = "nox", statistic = my.mean)

#alternative for 'third party' statistic
#trendLevel(mydata, pollutant = "nox", statistic = mean,
#           stat.args = list(na.rm = TRUE))
}
\author{
Karl Ropkins
}
\seealso{
\code{\link{openColours}} and \code{\link{drawOpenKey}} for more
  detailed plot control.
}
\keyword{methods}

