context("test-search_packages")

test_that("search_packages has the correct return format.", {
  skip_on_cran()
  output <- search_packages("dsjhjsghkldg")
  expect_is(output, "tbl_df")
  expect_equal(names(output), package_cols)
  expect_is(output$title, "character")
  expect_is(output$id, "character")
  expect_is(output$topics, "character")
  expect_is(output$civic_issues, "character")
  expect_is(output$excerpt, "character")
  expect_is(output$dataset_category, "character")
  expect_is(output$formats, "character")
  expect_is(output$refresh_rate, "character")
  expect_is(output$num_resources, "integer")
  expect_is(output$last_refreshed, "Date")

  output <- search_packages("ttc", limit = 1)
  expect_is(output, "tbl_df")
  expect_equal(names(output), package_cols)
  expect_is(output$title, "character")
  expect_is(output$id, "character")
  expect_is(output$topics, "character")
  expect_is(output$civic_issues, "character")
  expect_is(output$excerpt, "character")
  expect_is(output$dataset_category, "character")
  expect_is(output$formats, "character")
  expect_is(output$refresh_rate, "character")
  expect_is(output$num_resources, "integer")
  expect_is(output$last_refreshed, "Date")

  output <- search_packages("ttc-subway-shapefiles", limit = 1)
  expect_is(output, "tbl_df")
  expect_equal(names(output), package_cols)
  expect_is(output$title, "character")
  expect_is(output$id, "character")
  expect_is(output$topics, "character")
  expect_is(output$civic_issues, "character")
  expect_is(output$excerpt, "character")
  expect_is(output$dataset_category, "character")
  expect_is(output$formats, "character")
  expect_is(output$refresh_rate, "character")
  expect_is(output$num_resources, "integer")
  expect_is(output$last_refreshed, "Date")
})
