#' High School and Beyond survey
#'
#' Two hundred observations were randomly sampled from the High School and
#' Beyond survey, a survey conducted on high school seniors by the National
#' Center of Education Statistics.
#'
#'
#' @name hsb2
#' @docType data
#' @format A data frame with 200 observations and 11 variables. \describe{
#' \item{id}{Student ID.} \item{gender}{Student's gender, with levels
#' \code{female} and \code{male}.} \item{race}{Student's race, with levels
#' \code{african american}, \code{asian}, \code{hispanic}, and \code{white}.}
#' \item{ses}{Socio economic status of student's family, with levels
#' \code{low}, \code{middle}, and \code{high}.} \item{schtyp}{Type of school,
#' with levels \code{public} and \code{private}.} \item{prog}{Type of program,
#' with levels \code{general}, \code{academic}, and \code{vocational}.}
#' \item{read}{Standardized reading score.} \item{write}{Standardized writing
#' score.} \item{math}{Standardized math score.} \item{science}{Standardized
#' science score.} \item{socst}{Standardized social studies score.} }
#' @source UCLA Institute for Digital Research & Education - Statistical Consulting.
#' @keywords datasets
#' @examples
#'
#' library(ggplot2)
#'
#' ggplot(hsb2, aes(x = read - write, y = ses)) +
#'   geom_boxplot() +
#'   labs(
#'     x = "Difference between reading and writing scores",
#'     y = "Socio-economic status"
#'     )
#'
#'
"hsb2"
