% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.R
\name{position_seconds}
\alias{position_seconds}
\alias{position_seconds<-}
\alias{rewind}
\alias{set_position_order_row}
\title{Get and set ModPlug Tracker module position}
\usage{
position_seconds(mod, ...)

position_seconds(mod, ...) <- value

rewind(mod, ...)

set_position_order_row(mod, order, row, ...)
}
\arguments{
\item{mod}{A tracker module object of class \code{openmpt}.}

\item{...}{Ignored}

\item{value}{Position in seconds to move the player to. The value is rounded
to its nearest \code{order} and \code{row} position.}

\item{order}{Index of the position in the pattern sequence table (starts at \code{0}).}

\item{row}{Index of the row in the current pattern table (starts at \code{0}).}
}
\value{
Returns \code{NULL} invisibly, or the updated object in case of the assign operator (\verb{<-}).
}
\description{
Get or set the position of the music player. \code{rewind()} moves the position
to the start of the song.
}
\examples{
mod <- demo_mod()
position_seconds(mod)
position_seconds(mod) <- 10.2
set_position_order_row(mod, 1, 4)
rewind(mod)
}
