% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{nn}
\alias{nn}
\title{Nearest-neighbors method}
\usage{
nn(Y, X, control = NULL, wgt = rep(1, length(Y)), lambda = 100,
  sigma = 1, grp.size = 30, ...)
}
\arguments{
\item{Y}{outcome vector (must be numeric without NA's).}

\item{X}{numeric data frame or matrix of factors to be considered.}

\item{control}{numeric data frame or matrix of factors to control for. these are factors
that we can't consider while looking for the optimal intervention
(e.g. race).}

\item{wgt}{an optional vector of weights.}

\item{lambda}{the lagrange multiplier. also known as the shadow price of an
intervention.}

\item{sigma}{distance penalty for the nearest-neighbors method.}

\item{grp.size}{for the nearest-neighbors method; if the number of examples in each
control group is smaller than grp.size, performs weight adjustment
using \code{\link[optinterv]{wgt_adjust}}. else,
calculate weights seperatly for each control group.}

\item{...}{additional arguments.}
}
\value{
vector of adjusted weights under I = 1
}
\description{
Calculates adjusted weights under I = 1, using the nearest-neighbors method
}
