% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{prob.btwn}
\alias{prob.btwn}
\title{Probability Between}
\usage{
prob.btwn(spot, lower, upper, mean = 0, dsd, dte, p, quantile = FALSE)
}
\arguments{
\item{spot}{Current price of the underlying asset}

\item{lower}{Lower price of the range}

\item{upper}{Upper price of the range}

\item{mean}{The average daily price movement, default = 0}

\item{dsd}{Daily standard deviation of the underlying returns (Annual vol/sqrt(256))}

\item{dte}{Days until expiration, designated time frame}

\item{p}{Designated probability}

\item{quantile}{Logical. If True, calculates the probable price range}
}
\value{
Returns a probability (if quantile = FALSE), Returns a data.frame (if quantile = TRUE)
}
\description{
Calculates the probability of the underlying asset value falling between two prices in a designated time frame, given the daily standard devaiation of the underlying returns.
}
\details{
This function has two separate possible operations:
1. Calculates the probability of the underlying asset value falling between two prices in a designated time frame, given the daily standard devaiation of the underlying returns.
2. Calculates the probable price range, given a set probability
}
\examples{
prob.btwn(spot = 100, lower = 90, upper = 110, mean = 0, dsd = 0.01, dte = 45)
prob.btwn(spot = 100, mean = 0, dsd = 0.01, dte = 45, p = 0.75, quantile = TRUE)
}
