% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optionstrat.R
\name{calleval}
\alias{calleval}
\title{Call Option Evaluation}
\usage{
calleval(s, x, sigma, t, r, d = 0)
}
\arguments{
\item{s}{Spot price of the underlying asset}

\item{x}{Strike price of the option}

\item{sigma}{Implied volatility of the underlying asset price, defined as the annualized standard deviation of the asset returns}

\item{t}{Time to maturity in years}

\item{r}{Annual continuously-compounded risk-free rate, use the function r.cont}

\item{d}{Annual continuously-compounded dividend yield, use the function r.cont}
}
\value{
Returns a data.frame containing the option premium and greeks:
\itemize{
\item Premium
\item Delta
\item Gamma
\item Vega
\item Theta
\item Rho
}
}
\description{
Creates a data.frame containing call option greeks; delta, gamma, vega, theta, rho and the call premium
}
\examples{
calleval(100, 100, 0.20, (45/365), 0.02, 0.02)
}
\author{
John T. Buynak
}
