% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.optmatch.R
\name{print.optmatch}
\alias{print.optmatch}
\title{Printing \code{optmatch} objects.}
\usage{
\method{print}{optmatch}(x, quote = FALSE, grouped = FALSE, ...)
}
\arguments{
\item{x}{The \code{optmatch} object, as returned by
\code{\link{fullmatch}} or \code{\link{pairmatch}}.}

\item{quote}{A boolean indicating if the matched group names should
be quoted or not (default is not to quote).}

\item{grouped}{A logical indicating if the object should printed in
the style of a named \code{factor} object (\code{grouped = TRUE})
or as a table of group names and members.}

\item{...}{Arguments passed to \code{\link{print.default}}.}
}
\description{
Printing \code{optmatch} objects.
}
\examples{
data(nuclearplants)
fm <- fullmatch(pr ~ t1 + t2, data = nuclearplants)

print(fm)
print(fm, grouped = TRUE)
}
\seealso{
\code{\link{fullmatch}}, \code{\link{pairmatch}},
  \code{\link{print}}, \code{\link{summary.optmatch}}
}

