% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe_test.R
\name{orderly_test_start}
\alias{orderly_test_start}
\alias{orderly_test_check}
\title{Prepare a directory for orderly to use}
\usage{
orderly_test_start(
  name,
  parameters = NULL,
  envir = parent.frame(),
  root = NULL,
  locate = TRUE,
  instance = NULL,
  use_draft = FALSE,
  remote = NULL
)

orderly_test_check(path = NULL)
}
\arguments{
\item{name}{Name of the report to run (see
\code{\link[=orderly_list]{orderly_list()}}).  A leading \verb{src/} will be
removed if provided, allowing easier use of autocomplete.}

\item{parameters}{Parameters passed to the report. A named list of
parameters declared in the \code{orderly.yml}.  Each parameter
must be a scalar character, numeric, integer or logical.}

\item{envir}{The parent of the environment that will be used to
evaluate the report script; by default a new environment will be
made with the global environment as the parent.}

\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}

\item{instance}{Select instance of the source database to be used,
where multiple instances are configured.  Use a single
\emph{unnamed} character string to indicate an instance to
match.  If given, then this name must be present in all
databases where instances are listed in
\code{orderly_config.yml}, and will be ignored by all database
where instances are not given.  See the "orderly" vignette for
further information.}

\item{use_draft}{Should draft reports be used for dependencies?
This should be used only in development.  Valid values are
logical (\code{TRUE}, \code{FALSE}) or use the string
\code{newer} to use draft reports where they are newer than
archive reports.  For consistency, \code{always} and
\code{never} are equivalent to \code{TRUE} and \code{FALSE},
respectively.}

\item{remote}{Remote to use to resolve dependencies.  Use this in
order to run a report with the same dependencies as are
available on a remote server, particularly when using \code{id = "latest"}.  Note that this is not the same as running
\code{\link[=orderly_pull_dependencies]{orderly_pull_dependencies()}}, then \code{orderly_run}
with \code{remote = NULL}, as the pull/run approach will use the
latest report in \emph{your} archive but the \code{remote = "remote"} approach will use the latest approach in the
\emph{remote} archive (which might be less recent).}

\item{path}{Path to the report that is currently being run}
}
\value{
The path to the report directory
}
\description{
For interactive testing of orderly code.  This runs through and
sets everything up as orderly would (creates a new working
directory and copies files into it, pulls data from the database,
copies over any dependent reports) but then rather than running
the report hands back to the user.
}
\details{
Previous versions of orderly changed into the created directory
when using \code{orderly::orderly_test_start}, which allowed
interactive testing of a report, including ensuring that it has
created all expected outputs.  However, CRAN rules do not allow
changing the working directory, which significantly reduces the
usefulness of this function - as such we may remove it entirely in
a future version of orderly if it does not prove useful in this
more limited form.

The new suggested workflow is:
\enumerate{
\item run \code{orderly_test_start(...)} to prepare a report directory
\item manually change into that directory following the printed
instructions
\item use \code{orderly_test_check} to check that your report has created
the expected artefacts
\item manually change back to your original directory
}
}
\examples{

path <- orderly::orderly_example("minimal")
p <- orderly::orderly_test_start("example", root = path)

# The data in the orderly example is now available to use
dat

# Check to see which artefacts have been created so far:
orderly::orderly_test_check(p)

# Manually the code that this report has in its script
png(file.path(p, "mygraph.png"))
barplot(setNames(dat$number, dat$name), las = 2)
dev.off()

# We now confirm that the artefact has been created:
orderly::orderly_test_check(p)
}
