% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gfunction.R
\name{dg_glf}
\alias{dg_glf}
\title{Derivative of generalized logistic g function}
\usage{
dg_glf(v, par)
}
\arguments{
\item{v}{vector of standardized scores from the continuous ordinal scale, 0<\code{v}<1.}

\item{par}{vector of 2 elements: \code{B}, the slope of the curve, and \code{T}, the symmetry of the curve.}
}
\value{
A vector of length equal to the length of \code{v}, with values \eqn{g'(v)}.
}
\description{
Derivative of the generalized logistic function as in Richards (1959):
\deqn{g'(v) = \frac{T}{B}  \frac{1}{v(1-v^{T})}}
}
\author{
Maurizio Manuguerra, Gillian Heller
}
\references{
Richards, F. (1959). A flexible growth function for empirical use,
\emph{Journal of Experimental Botany}, 10, 290-301.
}
\seealso{
\code{\link{g_glf}},\code{\link{g_glf_inv}}
}
\keyword{Richards,}
\keyword{derivative,}
\keyword{function.}
\keyword{generalized}
\keyword{logistic}

