% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coef.ordinalNetFit}
\alias{coef.ordinalNetFit}
\title{Extracts fitted coefficients from an "ordinalNetFit" object.}
\usage{
\method{coef}{ordinalNetFit}(object, matrix = FALSE, whichLambda = NULL,
  criteria = c("aic", "bic"), ...)
}
\arguments{
\item{object}{An "ordinalNetFit" S3 object.}

\item{matrix}{Logical. If \code{TRUE}, coefficient estimates are returned in
matrix form. Otherwise a vector is returned.}

\item{whichLambda}{Optional index number of the desired \code{lambda} within
the sequence of \code{lambdaVals}. By default, the solution with the best AIC
is returned.}

\item{criteria}{Selects the best \code{lambda} value by AIC or BIC. Only used
if \code{whichLambda=NULL}.}

\item{...}{Not used. Additional coef arguments.}
}
\value{
The object returned depends on \code{matrix}.
}
\description{
Extracts fitted coefficients from an "ordinalNetFit" object.
}
\examples{
# Simulate x as independent standard normal
# Simulate y|x from a parallel cumulative logit (proportional odds) model
set.seed(1)
n <- 50
intercepts <- c(-1, 1)
beta <- c(1, 1, 0, 0, 0)
ncat <- length(intercepts) + 1  # number of response categories
p <- length(beta)  # number of covariates
x <- matrix(rnorm(n*p), ncol=p)  # n x p covariate matrix
eta <- c(x \%*\% beta) + matrix(intercepts, nrow=n, ncol=ncat-1, byrow=TRUE)
invlogit <- function(x) 1 / (1+exp(-x))
cumprob <- t(apply(eta, 1, invlogit))
prob <- cbind(cumprob, 1) - cbind(0, cumprob)
yint <- apply(prob, 1, function(p) sample(1:ncat, size=1, prob=p))
y <- as.factor(yint)

# Fit parallel cumulative logit model
fit <- ordinalNet(x, y)
coef(fit)
coef(fit, matrix=TRUE)

}
