% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{oscar.bs}
\alias{oscar.bs}
\title{Bootstrapping for oscar-fitted model objects}
\usage{
oscar.bs(fit, bootstrap = 100, seed = NULL, verb = 0, ...)
}
\arguments{
\item{fit}{oscar-model object}

\item{bootstrap}{Number of bootstrapped datasets, Default: 100}

\item{seed}{Random seed for reproducibility with NULL indicating that it is not set, Default: NULL}

\item{verb}{Level of verbosity with higher integer giving more information, Default: 0}

\item{...}{Additional parameters passed to oscar-function}
}
\value{
3-dimensional array with dimensions corresponding to k-steps, beta coefficients, and bootstrap runs
}
\description{
This model bootstraps the fitting of a given oscar object (re-fits the model for data that is equal in size but sampled with replacement). The output objects give insight into robustness of the oscar-coefficient path, as well as relative importance of model objects.
}
\details{
The function provides a fail-safe try-catch in an event of non-convergence of the model fitting procedure. This may occur for example if a bootstrapped data matrix has a column consist of a single value only over all observations.
}
\examples{
if(interactive()){
  data(ex)
  fit <- oscar(x=ex_X, y=ex_Y, k=ex_K, w=ex_c, family='cox')
  fit_bs <- oscar.cv(fit, bootstrap = 20, seed = 123)
  fit_bs
}
}
