% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-osmdata.R
\name{osmdata_pbf}
\alias{osmdata_pbf}
\title{Return an OSM Overpass query in PBF (Protocol Buffer Format).}
\usage{
osmdata_pbf(q, filename, quiet = TRUE)
}
\arguments{
\item{q}{An object of class `overpass_query` constructed with \code{opq} and
\code{add_osm_feature}.}

\item{filename}{If given, OSM data are saved to the named file}

\item{quiet}{suppress status messages.}
}
\value{
An binary Protocol Buffer Format (PBF) object.
}
\description{
Return an OSM Overpass query in PBF (Protocol Buffer Format).
}
\note{
This function is experimental, and \code{osmdata} can currently NOT do
anything with PBF files.
}
\examples{
\dontrun{
q <- opq ("hampi india")
q <- add_osm_feature (q, key="historic", value="ruins")
osmdata_pdf (q, filename="hampi.pbf")
}
}
