% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-network.R
\name{oe_get_network}
\alias{oe_get_network}
\title{Import transport network used by a specific mode of transport}
\usage{
oe_get_network(place, mode = c("cycling", "driving", "walking"), ...)
}
\arguments{
\item{place}{Description of the geographical area that should be matched with
a \code{.osm.pbf} file. Can be either a length-1 character vector, an
\code{sf}/\code{sfc}/\code{bbox} object, or a numeric vector of coordinates with length 2.
In the last case, it is assumed that the EPSG code is 4326 specified as
c(LON, LAT), while you can use any CRS with \code{sf}/\code{sfc}/\code{bbox} objects. See
Details and Examples in \code{\link[=oe_match]{oe_match()}}.}

\item{mode}{A character string denoting the desired mode of transport. Can be
abbreviated. Currently cycling (the default), driving and walking are supported.}

\item{...}{Additional arguments passed to \code{oe_get()} such as \code{boundary} or
\code{force_download}.}
}
\value{
An \code{sf} object.
}
\description{
This function is a wrapper around \code{oe_get()} and can be used to import a road
network given a \code{place} and a mode of transport. Check the Details for a
precise description of the procedures used to filter each mode of transport.
}
\details{
The definition of usable transport network was taken from the Python
packages \href{https://github.com/gboeing/osmnx/blob/main/osmnx/downloader.py}{osmnx} and
\href{https://pyrosm.readthedocs.io/en/latest/}{pyrosm} and several other
documents found online, i.e.
\url{https://wiki.openstreetmap.org/wiki/OSM_tags_for_routing/Access_restrictions},
\url{https://wiki.openstreetmap.org/wiki/Key:access}. See also the discussion
in \url{https://github.com/ropensci/osmextract/issues/153}.

The \code{cycling} mode of transport (i.e. the default value for \code{mode}
parameter) selects the OSM ways that meet the following conditions:
\itemize{
\item The \code{highway} tag is not missing and is not equal to \code{abandonded},
\code{bus_guideway}, \code{byway}, \code{construction}, \code{corridor}, \code{elevator}, \code{fixme},
\code{escalator}, \code{gallop}, \code{historic}, \code{no}, \code{planned}, \code{platform}, \code{proposed},
\code{raceway} or \code{steps};
\item The \code{highway} tag is not equal to \code{motorway}, \code{motorway_link}, \code{footway},
\code{bridleway} or \code{pedestrian} unless the tag \code{bicycle} is equal to \code{yes} (see
\href{https://wiki.openstreetmap.org/wiki/Bicycle#Bicycle_Restrictions}{here})
for more details;
\item The \code{access} tag is not equal to \code{private} or \code{no} unless \code{bicycle} tag
is equal to \code{yes};
\item The \code{bicycle} tag is not equal to \code{no}, \code{use_sidepath}, \code{private}, pr
\code{restricted};
\item The \code{service} tag does not contain the string \code{private} (i.e. \code{private};
\code{private_access} and similar);
}

The \code{walking} mode of transport selects the OSM ways that meet the
following conditions:
\itemize{
\item The \code{highway} tag is not missing and is not equal to \code{abandonded},
\code{bus_guideway}, \code{byway}, \code{construction}, \code{corridor}, \code{elevator}, \code{fixme},
\code{escalator}, \code{gallop}, \code{historic}, \code{no}, \code{planned}, \code{platform}, \code{proposed},
\code{raceway}, \code{motorway} or \code{motorway_link};
\item The \code{highway} tag is not equal to \code{cycleway} unless the \code{foot} tag is
equal to \code{yes};
\item The \code{access} tag is not equal to \code{private} or \code{no} unless \code{foot} tag
is equal to \code{yes};
\item The \code{foot} tag is not equal to \code{no}, \code{use_sidepath}, \code{private}, pr
\code{restricted};
\item The \code{service} tag does not contain the string \code{private} (i.e. \code{private};
\code{private_access} and similar).
}

The \code{driving} mode of transport selects the OSM ways that meet the
following conditions:
\itemize{
\item The \code{highway} tag is not missing and is not equal to \code{abandonded},
\code{bus_guideway}, \code{byway}, \code{construction}, \code{corridor}, \code{elevator}, \code{fixme},
\code{escalator}, \code{gallop}, \code{historic}, \code{no}, \code{planned}, \code{platform}, \code{proposed},
\code{cycleway}, \code{pedestrian}, \code{bridleway}, \code{path}, or \code{footway};
\item The \code{access} tag is not equal to \code{private} or \code{no};
\item The \code{service} tag does not contain the string \code{private} (i.e. \code{private};
\code{private_access} and similar).
}

Feel free to start a new issue in the \href{https://github.com/ropensci/osmextract}{github repo} if you want to suggest
modifications to the current filters or propose new values for alternative
modes of transport.
}
\examples{
# default value returned by OSM
its = oe_get("ITS Leeds", quiet = TRUE)
plot(its["highway"], lwd = 2, key.pos = 4, key.width = lcm(2.75))
# walking mode of transport
its_walking = oe_get_network("ITS Leeds", mode = "walking", quiet = TRUE)
plot(its_walking["highway"], lwd = 2, key.pos = 4, key.width = lcm(2.75))
# driving mode of transport
its_driving = oe_get_network("ITS Leeds", mode = "driving", quiet = TRUE)
plot(its_driving["highway"], lwd = 2, key.pos = 4, key.width = lcm(2.75))
}
\seealso{
\code{\link[=oe_get]{oe_get()}}
}
