/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose;

import fr.ird.osmose.Cell;
import fr.ird.osmose.IAggregation;
import fr.ird.osmose.Swarm;
import fr.ird.osmose.util.SimulationLinker;
import fr.ird.osmose.util.timeseries.SingleTimeSeries;
import java.util.HashMap;

public class Plankton
extends SimulationLinker {
    private final int index;
    private float trophicLevel;
    private double sizeMin;
    private double sizeMax;
    private String name;
    private double[] accessibilityCoeff;
    private double multiplier;
    private HashMap<Integer, Swarm> swarms;
    private final double accessMax = 0.99;

    public Plankton(int rank, int index) {
        super(rank);
        this.index = index;
    }

    public void init() {
        this.name = this.getConfiguration().getString("plankton.name.plk" + this.index);
        this.sizeMin = this.getConfiguration().getDouble("plankton.size.min.plk" + this.index);
        this.sizeMax = this.getConfiguration().getDouble("plankton.size.max.plk" + this.index);
        this.trophicLevel = this.getConfiguration().getFloat("plankton.tl.plk" + this.index);
        if (!this.getConfiguration().isNull("plankton.accessibility2fish.file.plk" + this.index)) {
            SingleTimeSeries ts = new SingleTimeSeries(this.getRank());
            ts.read(this.getConfiguration().getFile("plankton.accessibility2fish.file.plk" + this.index));
            this.accessibilityCoeff = ts.getValues();
        } else {
            double accessibility = this.getConfiguration().getDouble("plankton.accessibility2fish.plk" + this.index);
            this.accessibilityCoeff = new double[this.getConfiguration().getNStepYear() * this.getConfiguration().getNYear()];
            for (int i = 0; i < this.accessibilityCoeff.length; ++i) {
                this.accessibilityCoeff[i] = accessibility >= 1.0 ? 0.99 : accessibility;
            }
        }
        if (!this.getConfiguration().isNull("plankton.multiplier.plk" + this.index)) {
            this.multiplier = this.getConfiguration().getFloat("plankton.multiplier.plk" + this.index);
            this.warning("Plankton biomass for plankton group " + this.name + " will be multiplied by " + this.multiplier + " accordingly to parameter 'plankton.multiplier.plk'" + this.index + " from file " + this.getConfiguration().getSource("plankton.multiplier.plk" + this.index));
        } else {
            this.multiplier = 1.0;
        }
        this.swarms = new HashMap();
    }

    public double getBiomass(Cell cell) {
        return this.multiplier * this.getForcing().getBiomass(this.index, cell);
    }

    public double getAccessibleBiomass(Cell cell, int iStepSimu) {
        return this.accessibilityCoeff[iStepSimu] * this.getBiomass(cell);
    }

    public double getTotalBiomass() {
        double biomTot = 0.0;
        for (Cell cell : this.getGrid().getCells()) {
            if (cell.isLand()) continue;
            biomTot += this.getBiomass(cell);
        }
        return biomTot;
    }

    public double computePercent(double accessibleSizeMin, double accessibleSizeMax) {
        double tempPercent = (Math.min(this.sizeMax, accessibleSizeMax) - Math.max(this.sizeMin, accessibleSizeMin)) / (this.sizeMax - this.sizeMin);
        return tempPercent;
    }

    public double getSizeMax() {
        return this.sizeMax;
    }

    public double getSizeMin() {
        return this.sizeMin;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public int getIndex() {
        return this.index;
    }

    public float getTrophicLevel() {
        return this.trophicLevel;
    }

    public IAggregation getSwarm(Cell cell) {
        if (!this.swarms.containsKey(cell.getIndex())) {
            this.swarms.put(cell.getIndex(), new Swarm(this, cell));
        }
        return this.swarms.get(cell.getIndex());
    }

    public void updateSwarms(int iStepSimu) {
        for (Swarm swarm : this.swarms.values()) {
            swarm.updateBiomass(iStepSimu);
        }
    }
}

