/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.grid;

import au.com.bytecode.opencsv.CSVReader;
import fr.ird.osmose.Cell;
import fr.ird.osmose.grid.AbstractGrid;
import fr.ird.osmose.util.Separator;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

public class OriginalGrid
extends AbstractGrid {
    private int nline;
    private int ncolumn;
    private float latmax;
    private float latmin;
    private float lonmax;
    private float lonmin;

    @Override
    public void readParameters() {
        this.nline = this.getConfiguration().getInt("grid.nline");
        this.ncolumn = this.getConfiguration().getInt("grid.ncolumn");
        this.latmin = this.getConfiguration().getFloat("grid.lowright.lat");
        this.latmax = this.getConfiguration().getFloat("grid.upleft.lat");
        this.lonmax = this.getConfiguration().getFloat("grid.lowright.lon");
        this.lonmin = this.getConfiguration().getFloat("grid.upleft.lon");
    }

    @Override
    public Cell[][] makeGrid() {
        float dLat = (this.latmax - this.latmin) / (float)this.nline;
        float dLong = (this.lonmax - this.lonmin) / (float)this.ncolumn;
        Cell[][] grid = new Cell[this.nline][this.ncolumn];
        String filename = this.getConfiguration().getFile("grid.mask.file");
        boolean[][] land = this.readMaskAsCSV(filename);
        for (int j = 0; j < this.nline; ++j) {
            float latitude = this.latmin + ((float)j + 0.5f) * dLat;
            for (int i = 0; i < this.ncolumn; ++i) {
                float longitude = this.lonmin + (float)((double)i + 0.5) * dLong;
                grid[j][i] = new Cell(j * this.ncolumn + i, i, j, latitude, longitude, land[j][i]);
            }
        }
        return grid;
    }

    private boolean[][] readMaskAsCSV(String csvFile) {
        Object land = null;
        try {
            CSVReader reader = new CSVReader(new FileReader(csvFile), Separator.guess(csvFile).getSeparator());
            List<String[]> lines = reader.readAll();
            land = new boolean[lines.size()][];
            int ny = lines.size();
            int l = lines.size();
            while (l-- > 0) {
                String[] line = lines.get(l);
                int j = ny - l - 1;
                land[j] = new boolean[line.length];
                for (int i = 0; i < line.length; ++i) {
                    float val = Float.valueOf(line[i]).floatValue();
                    if (!(val < 0.0f)) continue;
                    land[j][i] = true;
                }
            }
        }
        catch (IOException ex) {
            this.error("Error reading grid mask from file " + csvFile, ex);
        }
        return land;
    }
}

